/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.apache.http.client.utils.DateUtils;
import org.opoo.ootp.client.Metadata;
import org.opoo.ootp.signer.Signer;

public class ExsMetadata
implements Metadata {
    private String id;
    private String type;
    private String from;
    private String to;
    private String repo;
    private String contentType;
    private Long contentLength;
    private String contentHash;
    private Date lastModified;
    private Map<String, String> userMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public void setUserMetadata(Map<String, String> userMetadata) {
        if (userMetadata == null) {
            this.userMetadata = null;
        } else {
            this.userMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.userMetadata.putAll(userMetadata);
        }
    }

    public String getUserMetadata(String name) {
        return this.userMetadata.get(name);
    }

    public String getDecodedUserMetadata(String name) {
        String value = this.getUserMetadata(name);
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public ExsMetadata addUserMetadata(String name, String value) {
        this.userMetadata.put(name, value);
        return this;
    }

    public ExsMetadata addEncodedUserMetadata(String name, String value) {
        if (value == null) {
            return this;
        }
        try {
            String encode = URLEncoder.encode(value, "UTF-8");
            return this.addUserMetadata(name, encode);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public ExsMetadata withType(String type) {
        this.setType(type);
        return this;
    }

    public ExsMetadata withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public ExsMetadata withContentLength(int contentLength) {
        this.setContentLength(Long.valueOf(contentLength));
        return this;
    }

    public ExsMetadata withContentLength(long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public ExsMetadata withContentHash(String contentHash) {
        this.setContentHash(contentHash);
        return this;
    }

    public ExsMetadata withFrom(String from) {
        this.setFrom(from);
        return this;
    }

    public ExsMetadata withTo(String to) {
        this.setTo(to);
        return this;
    }

    public ExsMetadata withRepo(String repo) {
        this.setRepo(repo);
        return this;
    }

    public ExsMetadata withId(String id) {
        this.setId(id);
        return this;
    }

    public ExsMetadata withLastModified(Date date) {
        this.setLastModified(date);
        return this;
    }

    public ExsMetadata withLastModified(long date) {
        this.setLastModified(new Date(date));
        return this;
    }

    public Map<String, String> toHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Optional.ofNullable(this.getType()).ifPresent(h -> headers.put(HEADER_EXS_TYPE, (String)h));
        Optional.ofNullable(this.getTo()).ifPresent(h -> headers.put(HEADER_EXS_TO, (String)h));
        Optional.ofNullable(this.getRepo()).ifPresent(h -> headers.put(HEADER_REPO, (String)h));
        Optional.ofNullable(this.getContentType()).ifPresent(h -> headers.put("content-type", (String)h));
        Optional.ofNullable(this.getContentHash()).ifPresent(h -> headers.put(Signer.HEADER_NAME_CONTENT_HASH, (String)h));
        Optional.ofNullable(this.getLastModified()).ifPresent(d -> headers.put("last-modified", DateUtils.formatDate((Date)d)));
        headers.putAll(ExsMetadata.getUmdHeaders(this.getUserMetadata()));
        return headers;
    }

    public void toHeaders(BiConsumer<String, String> headerSetter) {
        Optional.ofNullable(this.getType()).ifPresent(h -> headerSetter.accept(HEADER_EXS_TYPE, (String)h));
        Optional.ofNullable(this.getTo()).ifPresent(h -> headerSetter.accept(HEADER_EXS_TO, (String)h));
        Optional.ofNullable(this.getRepo()).ifPresent(h -> headerSetter.accept(HEADER_REPO, (String)h));
        Optional.ofNullable(this.getContentType()).ifPresent(h -> headerSetter.accept("content-type", (String)h));
        Optional.ofNullable(this.getContentHash()).ifPresent(h -> headerSetter.accept(Signer.HEADER_NAME_CONTENT_HASH, (String)h));
        Optional.ofNullable(this.getLastModified()).ifPresent(d -> headerSetter.accept("last-modified", DateUtils.formatDate((Date)d)));
        ExsMetadata.toUmdHeaders(this.getUserMetadata(), headerSetter);
    }

    public static Map<String, String> getUmdHeaders(Map<String, String> userMetadata) {
        HashMap<String, String> headers = new HashMap<String, String>();
        userMetadata.forEach((k, v) -> headers.put(HEADER_META_PREFIX + k, (String)v));
        return headers;
    }

    public static void toUmdHeaders(Map<String, String> userMetadata, BiConsumer<String, String> headerSetter) {
        userMetadata.forEach((k, v) -> headerSetter.accept(HEADER_META_PREFIX + k, (String)v));
    }

    public static ExsMetadata fromHeaders(Map<String, String> headers) {
        ExsMetadata metadata = new ExsMetadata();
        Optional.ofNullable(headers.get(HEADER_EXS_ID)).ifPresent(metadata::setId);
        Optional.ofNullable(headers.get(HEADER_EXS_TYPE)).ifPresent(metadata::setType);
        Optional.ofNullable(headers.get(HEADER_EXS_FROM)).ifPresent(metadata::setFrom);
        Optional.ofNullable(headers.get(HEADER_EXS_TO)).ifPresent(metadata::setTo);
        Optional.ofNullable(headers.get(HEADER_REPO)).ifPresent(metadata::setRepo);
        Optional.ofNullable(headers.get("content-type")).ifPresent(metadata::setContentType);
        Optional.ofNullable(headers.get("content-length")).map(Long::parseLong).ifPresent(metadata::setContentLength);
        Optional.ofNullable(headers.get(Signer.HEADER_NAME_CONTENT_HASH)).ifPresent(metadata::setContentHash);
        Optional.ofNullable(headers.get("last-modified")).map(DateUtils::parseDate).ifPresent(metadata::setLastModified);
        Map<String, String> userMetadata = ExsMetadata.getUserMetadata(headers);
        metadata.setUserMetadata(userMetadata);
        return metadata;
    }

    public static Map<String, String> getUserMetadata(Map<String, String> headers) {
        TreeMap<String, String> userMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.forEach((k, v) -> {
            String key = ExsMetadata.getUserMetadataKey(k);
            if (key != null) {
                userMetadata.put(key, (String)v);
            }
        });
        return userMetadata;
    }

    protected static String getUserMetadataKey(String headerName) {
        if (headerName.toLowerCase().startsWith(HEADER_META_PREFIX)) {
            return headerName.substring(HEADER_META_PREFIX_LENGTH);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getRepo() {
        return this.repo;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentHash(String contentHash) {
        this.contentHash = contentHash;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExsMetadata)) {
            return false;
        }
        ExsMetadata other = (ExsMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$contentLength = this.getContentLength();
        Long other$contentLength = other.getContentLength();
        if (this$contentLength == null ? other$contentLength != null : !((Object)this$contentLength).equals(other$contentLength)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$repo = this.getRepo();
        String other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$contentHash = this.getContentHash();
        String other$contentHash = other.getContentHash();
        if (this$contentHash == null ? other$contentHash != null : !this$contentHash.equals(other$contentHash)) {
            return false;
        }
        Date this$lastModified = this.getLastModified();
        Date other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        Map<String, String> this$userMetadata = this.getUserMetadata();
        Map<String, String> other$userMetadata = other.getUserMetadata();
        return !(this$userMetadata == null ? other$userMetadata != null : !((Object)this$userMetadata).equals(other$userMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExsMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $contentLength = this.getContentLength();
        result = result * 59 + ($contentLength == null ? 43 : ((Object)$contentLength).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $contentHash = this.getContentHash();
        result = result * 59 + ($contentHash == null ? 43 : $contentHash.hashCode());
        Date $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        Map<String, String> $userMetadata = this.getUserMetadata();
        result = result * 59 + ($userMetadata == null ? 43 : ((Object)$userMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "ExsMetadata(id=" + this.getId() + ", type=" + this.getType() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", repo=" + this.getRepo() + ", contentType=" + this.getContentType() + ", contentLength=" + this.getContentLength() + ", contentHash=" + this.getContentHash() + ", lastModified=" + this.getLastModified() + ", userMetadata=" + this.getUserMetadata() + ")";
    }
}

