/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.httpclient;

import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.protocol.HttpContext;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExsCodecHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExsCodecHttpRequestInterceptor.class);
    private final ExsCodec exsCodec;
    private String pathPrefix = "/ootpapi/open";

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        if (this.skip(httpRequest) || !(httpRequest instanceof HttpEntityEnclosingRequest)) {
            log.debug("\u65e0\u9700\u52a0\u5bc6\u5904\u7406: {}", (Object)httpRequest.getRequestLine().getUri());
            return;
        }
        HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)httpRequest;
        ExsMetadata exsMetadata = new ExsMetadata();
        Header firstHeader = request.getFirstHeader(Metadata.HEADER_EXS_TO);
        if (firstHeader != null) {
            exsMetadata.setTo(firstHeader.getValue());
        }
        HttpEntity encode = this.exsCodec.encode(request.getEntity(), exsMetadata);
        request.setEntity(encode);
        exsMetadata.toHeaders((arg_0, arg_1) -> ((HttpEntityEnclosingRequest)request).setHeader(arg_0, arg_1));
    }

    protected boolean skip(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        if (!"POST".equals(requestLine.getMethod())) {
            return true;
        }
        if (this.pathPrefix == null) {
            return true;
        }
        String uri = requestLine.getUri();
        String path = URI.create(uri).getPath();
        return !path.startsWith(this.pathPrefix);
    }

    public ExsCodecHttpRequestInterceptor(ExsCodec exsCodec) {
        this.exsCodec = exsCodec;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

