/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.httpclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;

public class ExsCodecHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final ExsCodec exsCodec;

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Arrays.stream(httpResponse.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
        ExsMetadata exsMetadata = ExsMetadata.fromHeaders(headers);
        HttpEntity decode = this.exsCodec.decode(httpResponse.getEntity(), exsMetadata);
        httpResponse.setEntity(decode);
    }

    public ExsCodecHttpResponseInterceptor(ExsCodec exsCodec) {
        this.exsCodec = exsCodec;
    }
}

