/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import cn.hutool.core.io.IoUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.opoo.ootp.client.ApiClient;
import org.opoo.ootp.client.ByteArrayBody;
import org.opoo.ootp.client.EntityBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.StringBody;
import org.opoo.ootp.client.impl.AbstractMessageClient;

public class ApiClientImpl
implements ApiClient {
    private final CloseableHttpClient httpClient;
    private final String baseUrl;
    private final ObjectMapper objectMapper;
    private ExsCodec codec;

    public ApiClientImpl(URI endpoint, CloseableHttpClient httpClient, ObjectMapper objectMapper, String openApiContextPath) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.baseUrl = endpoint.toString() + Optional.ofNullable(openApiContextPath).orElse("/ootpapi/open");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExsMessage post(String path, ExsMessage request) throws OotpException {
        ExsMetadata metadata = Objects.requireNonNull(request.getMetadata(), "metadata is required.");
        Objects.requireNonNull(metadata.getContentType(), "contentType is required.");
        ExsBody body = request.getBody();
        Objects.requireNonNull(body, "body is required.");
        HttpPost post = new HttpPost(this.baseUrl + path);
        try {
            HttpEntity httpEntity = AbstractMessageClient.toEntity(body, metadata);
            if (this.codec != null) {
                post.setEntity(this.codec.encode(httpEntity, metadata));
                metadata.toHeaders((arg_0, arg_1) -> ((HttpPost)post).setHeader(arg_0, arg_1));
            } else {
                post.setEntity(httpEntity);
            }
        }
        catch (IOException e) {
            throw new OotpException("\u5904\u7406\u8bf7\u6c42\u8f93\u5165\u65f6\u51fa\u9519", e);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            HttpEntity entity;
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                throw new OotpException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + statusCode + " - " + statusLine.getReasonPhrase() + "\n" + string, statusCode, statusLine.getReasonPhrase());
            }
            if (this.codec != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putIfAbsent(h.getName().toLowerCase(), h.getValue()));
                ExsMetadata responseMetadata = ExsMetadata.fromHeaders(headers);
                entity = this.codec.decode(response.getEntity(), responseMetadata);
            } else {
                entity = response.getEntity();
            }
            BufferedHttpEntity httpEntity = new BufferedHttpEntity(entity);
            ExsMessage exsMessage = new ExsMessage(new EntityBody((HttpEntity)httpEntity), metadata);
            return exsMessage;
        }
        catch (IOException ex) {
            throw new OotpException("API\u8c03\u7528\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }

    @Override
    public <T> T post(String path, Object request, Class<T> resultType) {
        ExsMessage exsMessage;
        Objects.requireNonNull(request, "request is required.");
        Objects.requireNonNull(resultType, "resultType is required.");
        Objects.requireNonNull(path, "path is required.");
        if (request instanceof ExsMessage) {
            exsMessage = (ExsMessage)request;
        } else {
            exsMessage = new ExsMessage();
            this.setMessageBody(exsMessage, request);
            exsMessage.setMetadata(new ExsMetadata());
            exsMessage.getMetadata().setContentType("application/json; charset=utf-8");
        }
        ExsMessage result = this.post(path, exsMessage);
        return this.convertResult(result, resultType);
    }

    private void setMessageBody(ExsMessage exsMessage, Object request) {
        if (request instanceof ExsBody) {
            exsMessage.setBody((ExsBody)request);
        } else if (request instanceof String) {
            exsMessage.setBody(new StringBody((String)request, StandardCharsets.UTF_8));
        } else if (request instanceof byte[]) {
            exsMessage.setBody(new ByteArrayBody((byte[])request));
        } else if (request instanceof InputStream) {
            exsMessage.setBody(new EntityBody((HttpEntity)new InputStreamEntity((InputStream)request)));
        } else {
            byte[] bytes;
            try {
                bytes = this.objectMapper.writeValueAsBytes(request);
            }
            catch (JsonProcessingException e) {
                throw new OotpException("\u8bf7\u6c42\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25", e);
            }
            exsMessage.setBody(new ByteArrayBody(bytes));
        }
    }

    private <T> T convertResult(ExsMessage result, Class<T> resultType) {
        try {
            if (ExsMessage.class.isAssignableFrom(resultType)) {
                return (T)result;
            }
            if (ExsBody.class.isAssignableFrom(resultType)) {
                return (T)result.getBody();
            }
            if (InputStream.class.isAssignableFrom(resultType)) {
                return (T)result.getBody().getContent();
            }
            if (String.class.isAssignableFrom(resultType)) {
                return (T)IoUtil.read((InputStream)result.getBody().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            if (byte[].class.isAssignableFrom(resultType)) {
                return (T)IoUtil.readBytes((InputStream)result.getBody().getContent());
            }
            return (T)this.objectMapper.readValue(result.getBody().getContent(), resultType);
        }
        catch (IOException e) {
            throw new OotpException("\u54cd\u5e94\u7ed3\u679c\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public void setCodec(ExsCodec codec) {
        this.codec = codec;
    }
}

