/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.impl;

import com.emc.codec.encryption.BasicKeyProvider;
import com.emc.codec.encryption.KeyProvider;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.opoo.ootp.client.KeyProviderManager;
import org.opoo.ootp.codec.encryption.BasicKeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.BasicPrivateKeyProvider;
import org.opoo.ootp.codec.encryption.KeyAndSpec;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleKeyProviderManager
implements KeyProviderManager {
    private static final Logger log = LoggerFactory.getLogger(SingleKeyProviderManager.class);
    private final KeyPair keyPair;
    private final KeyAndSpecProvider keyAndSpecProvider;

    public SingleKeyProviderManager(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.keyAndSpecProvider = null;
    }

    public SingleKeyProviderManager(PublicKey publicKey, PrivateKey privateKey) {
        this(new KeyPair(publicKey, privateKey));
    }

    public SingleKeyProviderManager(KeyAndSpec keyAndSpec) {
        this.keyPair = null;
        this.keyAndSpecProvider = new BasicKeyAndSpecProvider(keyAndSpec, new KeyAndSpec[0]);
    }

    public SingleKeyProviderManager(Key key) {
        this(new KeyAndSpec(key));
    }

    @Override
    public KeyAndSpecProvider getSM4KeyProvider(String to) {
        log.debug("\u67e5\u8be2 SM4 \u5bc6\u94a5 {}", (Object)(to != null ? ": " + to : ""));
        return this.keyAndSpecProvider;
    }

    @Override
    public PublicKey getSM2PublicKey(String to) {
        if (this.keyPair == null) {
            return null;
        }
        log.debug("\u67e5\u8be2 SM2 \u516c\u94a5 {}", (Object)(to != null ? ": " + to : ""));
        return this.keyPair.getPublic();
    }

    @Override
    public PrivateKeyProvider getSM2PrivateKeyProvider() {
        if (this.keyPair == null) {
            return null;
        }
        log.debug("\u67e5\u8be2 SM2 \u79c1\u94a5");
        return new BasicPrivateKeyProvider(new PrivateKey[]{this.keyPair.getPrivate()});
    }

    @Override
    public KeyProvider getRSAKeyProvider(String to) {
        if (this.keyPair == null) {
            return null;
        }
        log.debug("\u67e5\u8be2 RSA \u516c\u94a5\u548c\u79c1\u94a5 {}", (Object)(to != null ? ": " + to : ""));
        return new BasicKeyProvider(this.keyPair, new KeyPair[0]);
    }
}

