/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.spring;

import cn.hutool.core.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.opoo.ootp.client.ExsCodec;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.Metadata;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;

public class ExsCodecClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final ExsCodec exsCodec;
    private String openApiContextPath;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        byte[] newResponseBody;
        byte[] newBody;
        if (this.skip(request)) {
            return execution.execute(request, body);
        }
        HttpHeaders headers = request.getHeaders();
        MediaType contentType = headers.getContentType();
        ExsMetadata exsMetadata = new ExsMetadata();
        String extTo = headers.getFirst(Metadata.HEADER_EXS_TO);
        if (extTo != null) {
            exsMetadata.setTo(extTo);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(body);
             InputStream encodedStream = this.exsCodec.encode(inputStream, exsMetadata);){
            newBody = IoUtil.readBytes((InputStream)encodedStream, (boolean)false);
        }
        exsMetadata.toHeaders((arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1));
        headers.setContentLength((long)newBody.length);
        headers.setContentType(contentType);
        ClientHttpResponse response = execution.execute(request, newBody);
        HttpHeaders responseHeaders = new HttpHeaders((MultiValueMap)response.getHeaders());
        Map<String, String> map = responseHeaders.toSingleValueMap().entrySet().stream().map(en -> new AbstractMap.SimpleEntry(((String)en.getKey()).toLowerCase(), en.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ExsMetadata responseExsMetadata = ExsMetadata.fromHeaders(map);
        try (InputStream inputStream = this.exsCodec.decode(response.getBody(), responseExsMetadata);){
            newResponseBody = IoUtil.readBytes((InputStream)inputStream, (boolean)false);
        }
        responseHeaders.setContentLength((long)newResponseBody.length);
        return new ClientHttpResponseWrapper(response, responseHeaders, newResponseBody);
    }

    protected boolean skip(HttpRequest request) {
        if (request.getMethod() != HttpMethod.POST) {
            return true;
        }
        String path = request.getURI().getPath();
        String pathPrefix = this.openApiContextPath != null ? this.openApiContextPath : "/ootpapi/open";
        return !path.startsWith(pathPrefix);
    }

    public ExsCodecClientHttpRequestInterceptor(ExsCodec exsCodec) {
        this.exsCodec = exsCodec;
    }

    public void setOpenApiContextPath(String openApiContextPath) {
        this.openApiContextPath = openApiContextPath;
    }

    static class ClientHttpResponseWrapper
    implements ClientHttpResponse {
        private final ClientHttpResponse delegate;
        private final HttpHeaders headers;
        private final byte[] body;

        public HttpStatus getStatusCode() throws IOException {
            return this.delegate.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.delegate.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.delegate.getStatusText();
        }

        public void close() {
            this.delegate.close();
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public ClientHttpResponseWrapper(ClientHttpResponse delegate, HttpHeaders headers, byte[] body) {
            this.delegate = delegate;
            this.headers = headers;
            this.body = body;
        }
    }
}

