package org.opoo.ootp.client.messaging;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class ExsMessageTemplate extends AbstractMessageSendingTemplate<MessageChannel> {

    private String defaultTo;

    public void setDefaultTo(String to) {
        this.defaultTo = to;
    }

    public String getRequiredDefaultTo() {
        Assert.state(this.defaultTo != null, "No 'defaultTo' configured");
        return this.defaultTo;
    }

    @Override
    protected void doSend(MessageChannel destination, Message<?> message) {
        final MessageHeaders headers = message.getHeaders();
        if (headers.get(ExsMessageHeaders.TO, String.class) == null) {
            message = MessageBuilder.fromMessage(message).setHeader(ExsMessageHeaders.TO, getRequiredDefaultTo()).build();
        }
        destination.send(message);
    }

    public void convertAndSend(String type, String to, Object payload) throws MessagingException {
        final Message<Object> message = MessageBuilder.withPayload(payload)
                .setHeader(ExsMessageHeaders.TYPE, type)
                .setHeader(ExsMessageHeaders.TO, to)
                .setHeader(ExsMessageHeaders.CONTENT_TYPE, "application/json")
                .build();
        send(message);
    }

    public void convertAndSend(String type, Object payload) {
        convertAndSend(type, null, payload);
    }
}
