/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.util.List;
import org.opoo.ootp.client.ExsClient;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.messaging.PollableExsMessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.MessageConverter;

public class DefaultExsMessageDispatcher
implements PollableExsMessageDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultExsMessageDispatcher.class);
    private final SubscribableChannel subscribableChannel;
    private final MessageConverter messageConverter;
    private final ExsClient exsClient;
    private boolean defaultAutoAck = true;
    private boolean defaultFull = true;
    private int defaultLimit = 10;
    private boolean ignoreFailures = true;

    public DefaultExsMessageDispatcher(SubscribableChannel subscribableChannel, MessageConverter messageConverter, ExsClient exsClient) {
        this.subscribableChannel = subscribableChannel;
        this.messageConverter = messageConverter;
        this.exsClient = exsClient;
    }

    public boolean isDefaultAutoAck() {
        return this.defaultAutoAck;
    }

    public void setDefaultAutoAck(boolean defaultAutoAck) {
        this.defaultAutoAck = defaultAutoAck;
    }

    public boolean isDefaultFull() {
        return this.defaultFull;
    }

    public void setDefaultFull(boolean defaultFull) {
        this.defaultFull = defaultFull;
    }

    public int getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(int defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public void dispatch(ExsMessage exsMessage) {
        Message toMessage = this.messageConverter.toMessage((Object)exsMessage, null);
        if (toMessage == null) {
            if (this.isIgnoreFailures()) {
                log.warn("\u6d88\u606f\u8f6c\u6362\u5931\u8d25\uff0c\u8f6c\u6362\u540e\u4e3a\u7a7a\uff1a{}", (Object)exsMessage);
                return;
            }
            throw new IllegalStateException("\u6d88\u606f\u8f6c\u6362\u540e\u4e3a\u7a7a\uff1a" + exsMessage);
        }
        try {
            this.subscribableChannel.send(toMessage);
        }
        catch (RuntimeException e) {
            if (!this.isIgnoreFailures()) {
                if (e instanceof MessagingException && ((MessagingException)e).getFailedMessage() == null) {
                    throw new MessagingException(toMessage, "Failed to handle message", (Throwable)e);
                }
                throw e;
            }
            log.warn("\u6d88\u606f\u5206\u53d1\u5931\u8d25\u3002Suppressing Exception since 'ignoreFailures' is set to TRUE.", (Throwable)e);
        }
    }

    @Override
    public void dispatch(List<ExsMessage> messages) {
        for (ExsMessage message : messages) {
            this.dispatch(message);
        }
    }

    @Override
    public void pollAndDispatch(int limit, boolean autoAck, boolean full) {
        List messages = this.exsClient.poll(limit, autoAck, full);
        if (messages == null) {
            log.warn("\u8f6e\u8be2\u7ed3\u679c\u4e3a null");
            return;
        }
        int size = messages.size();
        log.debug("\u8f6e\u8be2\u6d88\u606f {} \u6761", (Object)size);
        if (size == 0) {
            return;
        }
        this.dispatch(messages);
        if (size >= limit) {
            this.pollAndDispatch(limit, autoAck, full);
        }
    }

    @Override
    public void pollAndDispatch() {
        this.pollAndDispatch(this.defaultLimit, this.defaultAutoAck, this.defaultFull);
    }
}

