/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opoo.ootp.client.ExsClient;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsModel;
import org.opoo.ootp.client.OotpException;
import org.opoo.ootp.client.messaging.ExsMessageConverter;
import org.opoo.ootp.client.messaging.ExsMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.converter.MessageConverter;

public class ExsMessageChannel
implements PollableChannel {
    private final ExsClient exsClient;
    private final MessageConverter messageConverter;
    private final ObjectMapper objectMapper;

    public ExsMessageChannel(ExsClient exsClient) {
        this.exsClient = exsClient;
        ExsMessageConverter messageConverter = new ExsMessageConverter();
        this.messageConverter = messageConverter;
        this.objectMapper = messageConverter.getObjectMapper();
    }

    public ExsMessageChannel(ExsClient exsClient, ExsMessageConverter messageConverter) {
        this.exsClient = exsClient;
        this.messageConverter = messageConverter;
        this.objectMapper = messageConverter.getObjectMapper();
    }

    public ExsMessageChannel(ExsClient exsClient, MessageConverter messageConverter, ObjectMapper objectMapper) {
        this.exsClient = exsClient;
        this.messageConverter = messageConverter;
        this.objectMapper = objectMapper;
    }

    public boolean send(Message<?> message, long timeout) {
        Object payload = message.getPayload();
        MessageHeaders headers = message.getHeaders();
        String to = (String)headers.get((Object)"to", String.class);
        String contentType = (String)headers.getOrDefault((Object)"contentType", (Object)"application/json");
        String type = Optional.ofNullable(headers.get((Object)"type", String.class)).orElseGet(() -> Optional.of(payload).filter(o -> o instanceof ExsModel).map(o -> ((ExsModel)o).getPrccod()).orElse(null));
        Objects.requireNonNull(type, "Header 'type' is required.");
        Objects.requireNonNull(to, "Header 'to' is required.");
        if (payload instanceof String) {
            this.exsClient.send(type, to, contentType, (String)payload);
        } else if (payload instanceof byte[]) {
            this.exsClient.send(type, to, contentType, (byte[])payload);
        } else {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes(payload);
                this.exsClient.send(type, to, contentType, bytes);
            }
            catch (JsonProcessingException e) {
                throw new OotpException("\u6d88\u606f\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            }
        }
        return true;
    }

    public Message<?> receive() {
        return this.receive(-1L);
    }

    public Message<?> receive(long timeout) {
        List messages = this.exsClient.poll(1, true, true);
        if (messages != null && !messages.isEmpty()) {
            ExsMessage message = (ExsMessage)messages.iterator().next();
            return this.messageConverter.toMessage((Object)message, (MessageHeaders)new ExsMessageHeaders());
        }
        return null;
    }
}

