/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsModel;
import org.opoo.ootp.client.messaging.ExsMessageHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.StringUtils;

public class ExsMessageConverter
implements MessageConverter,
SmartMessageConverter {
    private static final Logger log = LoggerFactory.getLogger(ExsMessageConverter.class);
    private final MappingJackson2MessageConverter delegate = new MappingJackson2MessageConverter();

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.delegate.setObjectMapper(objectMapper);
    }

    public ObjectMapper getObjectMapper() {
        return this.delegate.getObjectMapper();
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        boolean isByteArrayPayload;
        Object payload = message.getPayload();
        MessageHeaders headers = message.getHeaders();
        boolean isStringPayload = payload instanceof String;
        boolean bl = isByteArrayPayload = !isStringPayload && payload instanceof byte[];
        if (ExsMessage.class.isAssignableFrom(targetClass)) {
            ExsMessage exsMessage = (ExsMessage)headers.get((Object)"originalMessage", ExsMessage.class);
            if (exsMessage == null) {
                String from = (String)Objects.requireNonNull(headers.get((Object)"from", String.class), "Header 'from' is required.");
                String id = (String)Objects.requireNonNull(headers.get((Object)"_id", String.class), "Header 'id' is required.");
                String type = (String)Objects.requireNonNull(headers.get((Object)"type", String.class), "Header 'type' is required.");
                String contentType = (String)headers.get((Object)"contentType", String.class);
                exsMessage = new ExsMessage();
                exsMessage.setFrom(from);
                exsMessage.setId(id);
                exsMessage.setType(type);
                exsMessage.setContentType(contentType);
                if (isStringPayload) {
                    exsMessage.setBody((String)payload);
                } else if (isByteArrayPayload) {
                    exsMessage.setBody(new String((byte[])payload, StandardCharsets.UTF_8));
                } else {
                    try {
                        exsMessage.setBody(this.getObjectMapper().writeValueAsString(payload));
                    }
                    catch (JsonProcessingException e) {
                        throw new MessageConversionException("\u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            return exsMessage;
        }
        if (message.getHeaders().get((Object)"contentType") == null) {
            log.debug("Add 'contentType' header: {}", message);
            message = MessageBuilder.fromMessage(message).setHeader("contentType", (Object)"application/json").build();
        }
        return this.delegate.fromMessage(message, targetClass, conversionHint);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        String prccod;
        if (payload instanceof ExsMessage) {
            log.debug("Converting ExsMessage to Message: {}", payload);
            ExsMessage exsMessage = (ExsMessage)payload;
            return MessageBuilder.withPayload((Object)exsMessage.getBody()).copyHeaders((Map)headers).setHeader("type", (Object)exsMessage.getType()).setHeader("from", (Object)exsMessage.getFrom()).setHeader("contentType", (Object)exsMessage.getContentType()).setHeader("_id", (Object)exsMessage.getId()).setHeader("originalMessage", (Object)exsMessage).setHeaderIfAbsent("contentType", (Object)"application/json").build();
        }
        if (payload instanceof ExsModel && StringUtils.hasText((String)(prccod = ((ExsModel)payload).getPrccod()))) {
            headers = this.addHeaderIfAbsent(headers, "type", prccod);
        }
        headers = this.addHeaderIfAbsent(headers, "contentType", "application/json");
        return this.delegate.toMessage(payload, headers, conversionHint);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }

    protected MessageHeaders addHeaderIfAbsent(MessageHeaders headers, String name, String value) {
        if (headers == null) {
            log.debug("Create new MessageHeaders and add header '{}': {}", (Object)name, (Object)value);
            return new ExsMessageHeaders(Collections.singletonMap(name, value));
        }
        if (headers.get((Object)name) == null) {
            log.debug("Update MessageHeaders add header '{}': {}", (Object)name, (Object)value);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>((Map<String, Object>)headers);
            map.put(name, value);
            return new ExsMessageHeaders(map);
        }
        return headers;
    }
}

