/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class ExsMessageTemplate
extends AbstractMessageSendingTemplate<MessageChannel> {
    private String defaultTo;

    public void setDefaultTo(String to) {
        this.defaultTo = to;
    }

    public String getRequiredDefaultTo() {
        Assert.state((this.defaultTo != null ? 1 : 0) != 0, (String)"No 'defaultTo' configured");
        return this.defaultTo;
    }

    protected void doSend(MessageChannel destination, Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        if (headers.get((Object)"to", String.class) == null) {
            message = MessageBuilder.fromMessage(message).setHeader("to", (Object)this.getRequiredDefaultTo()).build();
        }
        destination.send(message);
    }

    public void convertAndSend(String type, String to, Object payload) throws MessagingException {
        Message message = MessageBuilder.withPayload((Object)payload).setHeader("type", (Object)type).setHeader("to", (Object)to).setHeader("contentType", (Object)"application/json").build();
        this.send(message);
    }

    public void convertAndSend(String type, Object payload) {
        this.convertAndSend(type, null, payload);
    }
}

