/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractExsMessageHandler
implements MessageHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<String> supportedTypes;

    public AbstractExsMessageHandler(String supportedType) {
        Assert.notNull((Object)supportedType, (String)"\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.supportedTypes = Collections.singletonList(supportedType);
    }

    public AbstractExsMessageHandler(String ... supportedTypes) {
        Assert.notEmpty((Object[])supportedTypes, (String)"\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.supportedTypes = Arrays.asList(supportedTypes);
    }

    public final void handleMessage(Message<?> message) throws MessagingException {
        MessageHeaders headers = message.getHeaders();
        String messageType = (String)headers.get((Object)"type", String.class);
        if (this.supports(messageType)) {
            this.handleMessageInternal(message);
        } else {
            this.log.debug("\u5f53\u524d\u6d88\u606f\u5904\u7406\u5668\u300c{}\u300d\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6d88\u606f\u7684\u5904\u7406\uff1a{}", this.supportedTypes, (Object)messageType);
        }
    }

    protected boolean supports(String messageType) {
        return this.supportedTypes.contains(messageType);
    }

    protected abstract void handleMessageInternal(Message<?> var1) throws MessagingException;
}

