/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.opoo.ootp.client.messaging.PollableExsMessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class ExsMessageListenerContainer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExsMessageListenerContainer.class);
    private final PollableExsMessageDispatcher messageDispatcher;
    private final TaskScheduler taskScheduler;
    private Duration delay = Duration.ofMinutes(5L);
    private Duration initialDelay = Duration.ofMinutes(1L);
    private boolean autoStart = true;
    private boolean running = false;

    public ExsMessageListenerContainer(PollableExsMessageDispatcher messageDispatcher, TaskScheduler taskScheduler) {
        this.messageDispatcher = messageDispatcher;
        this.taskScheduler = taskScheduler;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public PollableExsMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messageDispatcher, (String)"messageDispatcher is required.");
        Assert.notNull((Object)this.taskScheduler, (String)"taskScheduler is required.");
        if (this.autoStart) {
            this.start();
        }
    }

    public void start() {
        if (!this.running) {
            log.debug("\u542f\u52a8\u6d88\u606f\u76d1\u542c...");
            Runnable task = this.messageDispatcher::pollAndDispatch;
            if (this.taskScheduler instanceof ThreadPoolTaskScheduler) {
                ((ThreadPoolTaskScheduler)this.taskScheduler).getScheduledThreadPoolExecutor().scheduleWithFixedDelay(task, this.initialDelay.toMillis(), this.delay.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.taskScheduler.scheduleWithFixedDelay(task, this.delay);
            }
            this.running = true;
        } else {
            log.warn("\u6d88\u606f\u76d1\u542c\u7a0b\u5e8f\u5df2\u7ecf\u542f\u52a8");
        }
    }
}

