/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opoo.ootp.client.ByteArrayBody;
import org.opoo.ootp.client.ExsBody;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMetadata;
import org.opoo.ootp.client.ExsModel;
import org.opoo.ootp.client.StringBody;
import org.opoo.ootp.client.messaging.ExsMessageHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ExsMessageConverter
implements MessageConverter,
SmartMessageConverter {
    private static final Logger log = LoggerFactory.getLogger(ExsMessageConverter.class);
    private final MappingJackson2MessageConverter delegate = new MappingJackson2MessageConverter();

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.delegate.setObjectMapper(objectMapper);
    }

    public ObjectMapper getObjectMapper() {
        return this.delegate.getObjectMapper();
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        boolean isByteArrayPayload;
        Object payload = message.getPayload();
        MessageHeaders headers = message.getHeaders();
        boolean isStringPayload = payload instanceof String;
        boolean bl = isByteArrayPayload = !isStringPayload && payload instanceof byte[];
        if (ExsMessage.class.isAssignableFrom(targetClass)) {
            ExsMessage exsMessage = (ExsMessage)headers.get((Object)"originalMessage", ExsMessage.class);
            if (exsMessage == null) {
                String from = (String)headers.get((Object)"from", String.class);
                String id = (String)headers.get((Object)"_id", String.class);
                String contentType = (String)headers.get((Object)"contentType", String.class);
                String to = (String)headers.get((Object)"to", String.class);
                String contentHash = (String)headers.get((Object)"contentHash", String.class);
                Number contentLength = (Number)headers.get((Object)"contentLength", Number.class);
                String type = Optional.ofNullable(headers.get((Object)"type", String.class)).orElseGet(() -> Optional.of(payload).filter(o -> o instanceof ExsModel).map(o -> ((ExsModel)o).getPrccod()).orElse(null));
                Objects.requireNonNull(type, "Header 'type' is required.");
                ExsMetadata exsMetadata = new ExsMetadata();
                exsMetadata.setFrom(from);
                exsMetadata.setId(id);
                exsMetadata.setType(type);
                exsMetadata.setTo(to);
                exsMetadata.setContentHash(contentHash);
                exsMetadata.setContentType(contentType);
                exsMetadata.setContentLength(contentLength != null ? Long.valueOf(contentLength.longValue()) : null);
                headers.keySet().stream().filter(s -> s.toLowerCase().startsWith("meta-")).forEach(s -> exsMetadata.addUserMetadata(s, (String)headers.get(s, String.class)));
                Object body = isStringPayload ? new StringBody((String)payload) : (isByteArrayPayload ? new ByteArrayBody((byte[])payload) : new JsonBody(this.getObjectMapper(), payload));
                exsMessage = new ExsMessage((ExsBody)body, exsMetadata);
            }
            return exsMessage;
        }
        if (message.getHeaders().get((Object)"contentType") == null) {
            log.debug("Add 'contentType' header: {}", message);
            message = MessageBuilder.fromMessage(message).setHeader("contentType", (Object)"application/json;charset=UTF-8").build();
        }
        Charset charset = Optional.ofNullable(MessageHeaderAccessor.getAccessor(message)).map(MessageHeaderAccessor::getContentType).map(MimeType::getCharset).orElseGet(() -> Optional.ofNullable(headers.get((Object)"contentType", String.class)).map(MimeTypeUtils::parseMimeType).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8));
        log.debug("ContentType charset: {}", (Object)charset);
        if (byte[].class.equals(targetClass)) {
            if (isByteArrayPayload) {
                return payload;
            }
            if (isStringPayload) {
                return ((String)payload).getBytes(charset);
            }
            try {
                return this.getObjectMapper().writeValueAsBytes(payload);
            }
            catch (JsonProcessingException e) {
                throw new MessageConversionException(message, "\u6d88\u606f\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        }
        if (String.class.equals(targetClass)) {
            if (isStringPayload) {
                return payload;
            }
            if (isByteArrayPayload) {
                return new String((byte[])payload, charset);
            }
            try {
                return this.getObjectMapper().writeValueAsString(payload);
            }
            catch (JsonProcessingException e) {
                throw new MessageConversionException(message, "\u6d88\u606f\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        }
        return this.delegate.fromMessage(message, targetClass, conversionHint);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        String prccod;
        if (payload instanceof ExsMessage) {
            Object newPayload;
            log.debug("Converting ExsMessage to Message: {}", payload);
            ExsMessage exsMessage = (ExsMessage)payload;
            ExsMetadata metadata = exsMessage.getMetadata();
            ExsBody body = exsMessage.getBody();
            if (body instanceof StringBody) {
                newPayload = ((StringBody)body).getString();
            } else {
                try (InputStream inputStream = body.getContent();){
                    newPayload = StreamUtils.copyToByteArray((InputStream)inputStream);
                }
                catch (IOException e) {
                    throw new MessageConversionException("\u6d88\u606f\u65e0\u6cd5\u8f6c\u6362", (Throwable)e);
                }
            }
            MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)newPayload).copyHeaders((Map)headers).setHeader("type", (Object)metadata.getType()).setHeader("from", (Object)metadata.getFrom()).setHeader("to", (Object)metadata.getTo()).setHeader("contentType", (Object)metadata.getContentType()).setHeader("_id", (Object)metadata.getId()).setHeader("originalMessage", (Object)exsMessage).setHeaderIfAbsent("contentType", (Object)"application/json;charset=UTF-8");
            Optional.ofNullable(metadata.getContentHash()).ifPresent(s -> messageBuilder.setHeader("contentHash", s));
            Optional.ofNullable(metadata.getContentLength()).ifPresent(v -> messageBuilder.setHeader("contentLength", v));
            metadata.getUserMetadata().forEach((k, v) -> messageBuilder.setHeader("meta-" + k, v));
            return messageBuilder.build();
        }
        if (payload instanceof ExsModel && StringUtils.hasText((String)(prccod = ((ExsModel)payload).getPrccod()))) {
            headers = this.addHeaderIfAbsent(headers, "type", prccod);
        }
        headers = this.addHeaderIfAbsent(headers, "contentType", "application/json;charset=UTF-8");
        return this.delegate.toMessage(payload, headers, conversionHint);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }

    protected MessageHeaders addHeaderIfAbsent(MessageHeaders headers, String name, String value) {
        if (headers == null) {
            log.debug("Create new MessageHeaders and add header '{}': {}", (Object)name, (Object)value);
            return new ExsMessageHeaders(Collections.singletonMap(name, value));
        }
        if (headers.get((Object)name) == null) {
            log.debug("Update MessageHeaders add header '{}': {}", (Object)name, (Object)value);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>((Map<String, Object>)headers);
            map.put(name, value);
            return new ExsMessageHeaders(map);
        }
        return headers;
    }

    protected static class JsonBody
    implements ExsBody {
        private final ObjectMapper objectMapper;
        private final Object payload;

        public JsonBody(ObjectMapper objectMapper, Object payload) {
            this.objectMapper = objectMapper;
            this.payload = payload;
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            byte[] bytes = this.objectMapper.writeValueAsBytes(this.payload);
            return new ByteArrayInputStream(bytes);
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.objectMapper.writeValue(outputStream, this.payload);
        }
    }
}

