package org.opoo.ootp.client.messaging;

import org.springframework.messaging.MessageHeaders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ExsMessageHeaders extends MessageHeaders {
    public static final String TO = "to";
    public static final String TYPE = "type";
    public static final String FROM = "from";
    public static final String ID = "_id";
    public static final String CONTENT_HASH = "contentHash";
    public static final String CONTENT_LENGTH = "contentLength";
    public static final String ORIGINAL_MESSAGE = "originalMessage";

    public static final String DEFAULT_CONTENT_TYPE = "application/json;charset=UTF-8";

    public ExsMessageHeaders() {
        this(new LinkedHashMap<>());
    }

    public ExsMessageHeaders(Map<String, Object> headers) {
        super(headers);
    }

    protected ExsMessageHeaders(Map<String, Object> headers, UUID id, Long timestamp) {
        super(headers, id, timestamp);
    }
}
