package org.opoo.ootp.client.messaging;

public class ReturnMessageException extends RuntimeException {
    private final String messageId;

    public ReturnMessageException() {
        this.messageId = null;
    }

    public ReturnMessageException(String messageId) {
        this.messageId = messageId;
    }

    public ReturnMessageException(String message, Throwable cause) {
        super(message, cause);
        this.messageId = null;
    }

    public ReturnMessageException(Throwable cause) {
        super(cause);
        this.messageId = null;
    }

    public ReturnMessageException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.messageId = null;
    }

    public ReturnMessageException(String message, String messageId) {
        super(message);
        this.messageId = messageId;
    }

    public ReturnMessageException(String message, Throwable cause, String messageId) {
        super(message, cause);
        this.messageId = messageId;
    }

    public ReturnMessageException(Throwable cause, String messageId) {
        super(cause);
        this.messageId = messageId;
    }

    public ReturnMessageException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String messageId) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.messageId = messageId;
    }

    public String getMessageId() {
        return messageId;
    }
}
