/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageLite;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.PollRequest;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.messaging.ExsMessageHeaders;
import org.opoo.ootp.client.messaging.PollableExsMessageDispatcher;
import org.opoo.ootp.client.messaging.ReturnMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.MessageConverter;

public class DefaultExsMessageDispatcher
implements PollableExsMessageDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultExsMessageDispatcher.class);
    private final SubscribableChannel subscribableChannel;
    private final MessageConverter messageConverter;
    private final MessageClient messageClient;
    private String clientId;
    private int defaultLimit = 10;
    private boolean ignoreFailures = true;
    private final List<Class<? extends Exception>> returnMessageExceptionTypes = new ArrayList<Class<? extends Exception>>();

    public DefaultExsMessageDispatcher(SubscribableChannel subscribableChannel, MessageConverter messageConverter, MessageClient messageClient) {
        this.subscribableChannel = subscribableChannel;
        this.messageConverter = messageConverter;
        this.messageClient = messageClient;
        this.addReturnMessageExceptionTypes(ReturnMessageException.class);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(int defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public List<Class<? extends Exception>> getReturnMessageExceptionTypes() {
        return this.returnMessageExceptionTypes;
    }

    public void addReturnMessageExceptionTypes(Class<? extends Exception> returnMessageExceptionType) {
        this.returnMessageExceptionTypes.add(returnMessageExceptionType);
    }

    @Override
    public void dispatch(ExsMessage exsMessage) {
        Message toMessage = this.messageConverter.toMessage((Object)exsMessage, (MessageHeaders)new ExsMessageHeaders());
        this.subscribableChannel.send(Objects.requireNonNull(toMessage, "\u8f6c\u6362\u540e\u7684\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    @Override
    public void dispatch(List<ExsMessage> messages) {
        for (ExsMessage message : messages) {
            this.dispatch(message);
        }
    }

    @Override
    public void pollAndDispatch(int limit) {
        this.pollAndDispatch(limit, null);
    }

    @Override
    public void pollAndDispatch() {
        this.pollAndDispatch(this.defaultLimit, null);
    }

    private void pollAndDispatch(int limit, String latestId) {
        PollResult pollResult;
        PollRequest pollRequest = new PollRequest(limit, true, false, latestId, this.clientId);
        try {
            pollResult = this.messageClient.poll(pollRequest);
        }
        catch (Exception e) {
            log.error("\u8f6e\u8be2\u65f6\u51fa\u9519\uff0c\u5ffd\u7565\u672c\u6b21\u8f6e\u8be2\u7ed3\u679c", (Throwable)e);
            return;
        }
        if (pollResult == null) {
            log.warn("\u8f6e\u8be2\u7ed3\u679c\u4e3a null");
            return;
        }
        List messages = pollResult.getMessages();
        int size = messages.size();
        log.debug("\u8f6e\u8be2\u6d88\u606f {} \u6761", (Object)size);
        messages.forEach(this::dispatch);
        if (pollResult.hasNext()) {
            this.pollAndDispatch(limit, pollRequest.getLatestId());
        }
    }

    public void dispatch(ExsMessageLite lite) {
        String messageId = lite.getMetadata().getId();
        try {
            this.dispatch(this.messageClient.getMessage(messageId));
        }
        catch (Exception e) {
            if (this.returnMessageExceptionTypes.stream().anyMatch(type -> type.isInstance(e))) {
                log.warn("\u6d88\u606f\u5904\u7406\u51fa\u9519\uff0c\u6839\u636e\u914d\u7f6e\uff0c\u53d1\u751f\u6b64\u5f02\u5e38\u5c06\u56de\u9000\u6d88\u606f\uff1a{} - {}", (Object)messageId, (Object)e);
                this.tryReturnMessage(messageId);
                return;
            }
            if (this.isIgnoreFailures()) {
                log.warn("\u6d88\u606f\u5904\u7406\u5931\u8d25\uff0c\u5ffd\u7565\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
                return;
            }
            throw e;
        }
    }

    private void tryReturnMessage(String messageId) {
        try {
            int rows = this.messageClient.ret(new String[]{messageId});
            log.info("\u6d88\u606f\u9000\u56de\uff1a{}", (Object)rows);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u9000\u56de\u5931\u8d25\uff1a{}", (Object)messageId, (Object)e);
        }
    }
}

