/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.util.Objects;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageLite;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.PollResult;
import org.opoo.ootp.client.messaging.ExsMessageConverter;
import org.opoo.ootp.client.messaging.ExsMessageHeaders;
import org.opoo.ootp.client.messaging.SendContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.converter.MessageConverter;

public class ExsMessageChannel
implements PollableChannel {
    private static final Logger log = LoggerFactory.getLogger(ExsMessageChannel.class);
    private final MessageClient messageClient;
    private final MessageConverter messageConverter;

    public ExsMessageChannel(MessageClient messageClient) {
        this.messageClient = messageClient;
        this.messageConverter = new ExsMessageConverter();
    }

    public ExsMessageChannel(MessageClient messageClient, ExsMessageConverter messageConverter) {
        this.messageClient = messageClient;
        this.messageConverter = messageConverter;
    }

    public ExsMessageChannel(MessageClient messageClient, MessageConverter messageConverter) {
        this.messageClient = messageClient;
        this.messageConverter = messageConverter;
    }

    public String sendAndReturn(Message<?> message, long timeout) {
        ExsMessage exsMessage = (ExsMessage)this.messageConverter.fromMessage(message, ExsMessage.class);
        Objects.requireNonNull(exsMessage, "\u8f6c\u6362\u540e\u7684\u6d88\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(exsMessage.getMetadata(), "\u6d88\u606f\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(exsMessage.getMetadata().getTo(), "Header 'to' is required.");
        String id = this.messageClient.send(exsMessage);
        log.debug("\u53d1\u9001\u540e\u6d88\u606fID\uff1a{}", (Object)id);
        SendContextHolder.setMessageId(id);
        return id;
    }

    public boolean send(Message<?> message, long timeout) {
        this.sendAndReturn(message, timeout);
        return true;
    }

    public Message<?> receive() {
        return this.receive(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        PollResult pollResult = this.messageClient.poll(1, false, false);
        if (pollResult != null && !pollResult.getMessages().isEmpty()) {
            Message message;
            ExsMessageLite messageLite = (ExsMessageLite)pollResult.getMessages().iterator().next();
            String id = messageLite.getMetadata().getId();
            ExsMessage exsMessage = this.messageClient.getMessage(id);
            try {
                message = this.messageConverter.toMessage((Object)exsMessage, (MessageHeaders)new ExsMessageHeaders());
            }
            catch (Throwable throwable) {
                int ack = this.messageClient.ack(new String[]{id});
                log.debug("Ack result: {}", (Object)ack);
                throw throwable;
            }
            int ack = this.messageClient.ack(new String[]{id});
            log.debug("Ack result: {}", (Object)ack);
            return message;
        }
        return null;
    }
}

