/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.client.messaging;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Validator;

public class MethodExsMessageHandler
extends AbstractMethodMessageHandler<MessageMapping> {
    public static final String DEFAULT_DESTINATION = "default";
    private MessageConverter messageConverter;
    private ConversionService conversionService = new DefaultFormattingConversionService();
    @Nullable
    private Validator validator;

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Nullable
    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(@Nullable Validator validator) {
        this.validator = validator;
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ApplicationContext context = this.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : null;
        ArrayList<Object> resolvers = new ArrayList<Object>();
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new DestinationVariableMethodArgumentResolver(this.conversionService));
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver(this.messageConverter));
        resolvers.addAll(this.getCustomArgumentResolvers());
        resolvers.add(new PayloadMethodArgumentResolver(this.messageConverter, this.validator));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return Collections.singletonList(new HandlerMethodReturnValueHandler(){

            public boolean supportsReturnType(MethodParameter returnType) {
                return true;
            }

            public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
            }
        });
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Component.class) || AnnotatedElementUtils.hasAnnotation(beanType, Controller.class);
    }

    protected MessageMapping getMappingForMethod(Method method, Class<?> handlerType) {
        MessageMapping messageAnn = (MessageMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, MessageMapping.class);
        if (messageAnn != null && messageAnn.value().length > 0) {
            return messageAnn;
        }
        return null;
    }

    protected Set<String> getDirectLookupDestinations(MessageMapping mapping) {
        return Collections.singleton(DEFAULT_DESTINATION);
    }

    protected String getDestination(Message<?> message) {
        return DEFAULT_DESTINATION;
    }

    protected MessageMapping getMatchingMapping(MessageMapping mapping, Message<?> message) {
        String type = (String)Objects.requireNonNull(message.getHeaders().get((Object)"type", String.class));
        if (Arrays.asList(mapping.value()).contains(type)) {
            return mapping;
        }
        return null;
    }

    protected Comparator<MessageMapping> getMappingComparator(Message<?> message) {
        return null;
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }
}

