package org.opoo.ootp.client.messaging;

import lombok.extern.slf4j.Slf4j;
import org.opoo.ootp.client.ExsMessage;
import org.opoo.ootp.client.ExsMessageLite;
import org.opoo.ootp.client.MessageClient;
import org.opoo.ootp.client.PollResult;
import org.springframework.messaging.Message;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.converter.MessageConverter;

import java.util.Objects;

@Slf4j
public class ExsMessageChannel implements PollableChannel {
    private final MessageClient messageClient;
    private final MessageConverter messageConverter;

    public ExsMessageChannel(MessageClient messageClient) {
        this.messageClient = messageClient;
        this.messageConverter = new ExsMessageConverter();
    }

    public ExsMessageChannel(MessageClient messageClient, ExsMessageConverter messageConverter) {
        this.messageClient = messageClient;
        this.messageConverter = messageConverter;
    }

    public ExsMessageChannel(MessageClient messageClient, MessageConverter messageConverter) {
        this.messageClient = messageClient;
        this.messageConverter = messageConverter;
    }

    /**
     * 发送消息并返回发送的消息的ID
     *
     * @param message 消息
     * @param timeout 超时时间
     * @return 消息发送异常
     */
    public String sendAndReturn(Message<?> message, long timeout) {
        final ExsMessage exsMessage = (ExsMessage) messageConverter.fromMessage(message, ExsMessage.class);
        Objects.requireNonNull(exsMessage, "转换后的消息对象不能为空");
        Objects.requireNonNull(exsMessage.getMetadata(), "消息元数据不能为空");
        Objects.requireNonNull(exsMessage.getMetadata().getTo(), "Header 'to' is required.");

        final String id = messageClient.send(exsMessage);
        log.debug("发送后消息ID：{}", id);
        SendContextHolder.setMessageId(id);
        return id;
    }

    @Override
    public boolean send(Message<?> message, long timeout) {
        sendAndReturn(message, timeout);

//
//        final Object payload = message.getPayload();
//        final MessageHeaders headers = message.getHeaders();
//        //final String to = headers.get(TO, String.class);
//        final String contentType = (String) headers.getOrDefault(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
//        final String type = Optional.ofNullable(headers.get(TYPE, String.class))
//                .orElseGet(() ->
//                    Optional.of(payload)
//                        .filter(o -> o instanceof ExsModel)
//                        .map(o -> ((ExsModel) o).getPrccod())
//                        .orElse(null)
//                );
//
//        Objects.requireNonNull(type, "Header 'type' is required.");
//        Objects.requireNonNull(to, "Header 'to' is required.");
//
//        exsMessage.getMetadata().withType(type).withContentType(contentType);
//
//        if (payload instanceof String) {
//            messageClient.send(type, to, contentType, (String) payload);
//        } else if (payload instanceof byte[]) {
//            messageClient.send(type, to, contentType, (byte[]) payload);
//        } else {
//            // convert
//            try {
//                final byte[] bytes = objectMapper.writeValueAsBytes(payload);
//                messageClient.send(type, to, contentType, bytes);
//            } catch (JsonProcessingException e) {
//                throw new OotpException("消息序列化失败", e);
//            }
//        }
        return true;
    }

    @Override
    public Message<?> receive() {
        return receive(INDEFINITE_TIMEOUT);
    }

    @Override
    public Message<?> receive(long timeout) {
        final PollResult pollResult = messageClient.poll(1, false, false);

        if (pollResult != null && !pollResult.getMessages().isEmpty()) {
            final ExsMessageLite messageLite = pollResult.getMessages().iterator().next();
            final String id = messageLite.getMetadata().getId();
            final ExsMessage exsMessage = messageClient.getMessage(id);

            try {
                return messageConverter.toMessage(exsMessage, new ExsMessageHeaders());
            } finally {
                final int ack = messageClient.ack(id);
                log.debug("Ack result: {}", ack);
            }
        }
        return null;
    }

}
