package org.opoo.ootp.client.messaging;

/**
 * 轮询并分发消息。可在线程池中或者定时任务中调度。
 * <p>
 * 在支持集群（例如 quartz）的定时任务中使用时，可以手动确认消息。在多实例部署本地线程池中轮询消息时，
 * 一般将 autoAck 和 full 都设置为 true，防止消息被重复消费。
 */
public interface PollableExsMessageDispatcher extends ExsMessageDispatcher {
    /**
     * 轮询消息。
     *
     * @param limit 每批次消息最大数量
     */
    void pollAndDispatch(int limit);

    /**
     * 轮询消息，使用当前分发程序默认的配置。
     */
    void pollAndDispatch();
}
