/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer.spring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class SignerClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SignerClientHttpRequestInterceptor.class);
    private final Signer signer;

    public SignerClientHttpRequestInterceptor(Signer signer) {
        this.signer = signer;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        this.extractParameters(request, (MultiValueMap<String, String>)params);
        HttpHeaders headers = request.getHeaders();
        Optional<String> contentHashOpt = Optional.ofNullable(headers.getFirst(Signer.HEADER_NAME_CONTENT_HASH));
        log.debug("\u662f\u5426\u9700\u8981\u8ba1\u7b97\u5185\u5bb9\u7684\u54c8\u5e0c\uff1a{}", (Object)(!contentHashOpt.isPresent() ? 1 : 0));
        String contentHash = contentHashOpt.isPresent() ? contentHashOpt.get() : this.calculateContentHash(body);
        String authorization = this.signer.buildAuthorization(Optional.ofNullable(request.getMethod()).map(Enum::name).orElse(""), request.getURI().getPath(), headers.toSingleValueMap(), params.toSingleValueMap(), contentHash);
        log.debug("Auth\uff1a{}", (Object)authorization);
        headers.set("Authorization", authorization);
        return execution.execute(request, body);
    }

    private void extractParameters(HttpRequest request, MultiValueMap<String, String> params) {
        MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
        for (Map.Entry entry : queryParams.entrySet()) {
            params.put(entry.getKey(), this.decodeStringList((List)entry.getValue()));
        }
    }

    private List<String> decodeStringList(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : list) {
            if (string == null) {
                result.add(null);
                continue;
            }
            try {
                result.add(URLDecoder.decode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                if (log.isDebugEnabled()) {
                    log.error("URL \u89e3\u7801\u5931\u8d25\uff0c\u5ffd\u7565\u89e3\u7801\u7ed3\u679c\uff1a" + string, (Throwable)ex);
                }
                result.add(string);
            }
        }
        return result;
    }

    private String calculateContentHash(byte[] body) throws IOException {
        ByteArrayInputStream inputStream = body != null && body.length > 0 ? new ByteArrayInputStream(body) : null;
        return this.signer.hash(inputStream);
    }
}

