package org.opoo.ootp.signer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public interface Signer {
    String SIGNER_ID = new String(new byte[]{0x43, 0x4d, 0x42});
    String SCHEME = SIGNER_ID + "1";
    String HEADER_NAME_PREFIX = "x-" + SIGNER_ID.toLowerCase() + "-";
    String HEADER_NAME_CONTENT_HASH = HEADER_NAME_PREFIX + "content-hash";

    String ATTR_SIGNER_SKIP = "signer.skip";

    /**
     * 组装 Authorization 头信息
     * @param httpMethod 请求方法
     * @param resourcePath 请求资源
     * @param headers 用于签名的头
     * @param parameters 用于签名的参数
     * @param contentHash 请求内容的哈希值
     * @return 组装好的 Authorization 头
     */
    String buildAuthorization(String httpMethod, String resourcePath,
                              Map<String,String> headers,
                              Map<String,String> parameters,
                              String contentHash);

    /**
     * 计算内容的哈希值。
     * @param content 请求内容
     * @return 哈希值，通常是 HEX 编码后的字符串
     */
    String hash(String content);

    /**
     * 计算内容的哈希值。
     * @param inputStream 请求内容
     * @return 哈希值，通常是 HEX 编码后的字符串
     * @throws IOException 对流计算哈希时可能出现的 IO 异常
     */
    String hash(InputStream inputStream) throws IOException;

    /**
     * 使用指定的 key 对被签名的字符串进行签名，通常使用 HMAC 算法。
     * @param key 指定的密钥
     * @param stringToSign 待签名的字符串
     * @return 签名的 HEX 编码字符串或者 Base64 编码字符串
     * @deprecated 使用 {@link #sign(String)} 替代
     */
    @Deprecated
    String sign(String key, String stringToSign);

    /**
     * 使用指定的 key 对被签名的字符串进行签名，通常使用 HMAC 算法或者非对称加密解密算法。
     * @param stringToSign 待签名的字符串
     * @return 签名的 HEX 编码字符串或者 Base64 编码字符串
     */
    String sign(String stringToSign);
}
