/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.opoo.ootp.signer.AbstractSigner;

public class JCESigner
extends AbstractSigner {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String ALGORITHM = "HMAC-SHA256";

    public JCESigner(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    @Override
    public String hash(String content) {
        if (content == null || content.isEmpty()) {
            return EMPTY_BODY_SHA256;
        }
        return DigestUtils.sha256Hex((String)content);
    }

    @Override
    public String hash(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return EMPTY_BODY_SHA256;
        }
        try (InputStream is = inputStream;){
            String string = DigestUtils.sha256Hex((InputStream)is);
            return string;
        }
    }

    @Override
    @Deprecated
    public String sign(String key, String stringToSign) {
        return this.sign(stringToSign);
    }

    @Override
    public String sign(String stringToSign) {
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, this.getSecretKey()).hmacHex(stringToSign);
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }
}

