/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer;

import cn.hutool.crypto.SmUtil;
import java.io.IOException;
import java.io.InputStream;
import org.opoo.ootp.signer.AbstractSigner;

public class SM3Signer
extends AbstractSigner {
    public static final String EMPTY_BODY_SM3 = SIGNER_ID + "-SM-CRYPT-EMPTY-HASH";
    public static final String ALGORITHM = "HMAC-SM3";

    public SM3Signer(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    protected String getEmptyBodySm3() {
        return EMPTY_BODY_SM3;
    }

    @Override
    public String hash(String content) {
        if (content == null || content.isEmpty()) {
            return this.getEmptyBodySm3();
        }
        return SmUtil.sm3().digestHex(content);
    }

    @Override
    public String hash(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return this.getEmptyBodySm3();
        }
        try (InputStream is = inputStream;){
            String string = SmUtil.sm3().digestHex(is);
            return string;
        }
    }

    @Override
    @Deprecated
    public String sign(String key, String stringToSign) {
        return this.sign(stringToSign);
    }

    @Override
    public String sign(String stringToSign) {
        byte[] halfKey = SmUtil.sm3().digest(this.getSecretKey());
        byte[] fullKey = new byte[64];
        System.arraycopy(halfKey, 0, fullKey, 0, 32);
        System.arraycopy(halfKey, 0, fullKey, 32, 32);
        return SmUtil.hmacSm3((byte[])fullKey).digestHex(stringToSign);
    }
}

