/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer;

import cn.hutool.crypto.SmUtil;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.function.Supplier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opoo.ootp.signer.SM3SignerV2;

public class SM3WithSM2Signer
extends SM3SignerV2 {
    public static final String ALGORITHM = "SM3withSM2";
    private static final String INVALID_SECRET_KEY = "invalid-secret-key";
    private final PrivateKey privateKey;

    public SM3WithSM2Signer(String accessKey, PrivateKey privateKey) {
        super(accessKey, null);
        this.privateKey = privateKey;
    }

    public SM3WithSM2Signer(String accessKey, String privateKeyBase64) {
        this(accessKey, () -> Base64.getDecoder().decode(privateKeyBase64));
    }

    public SM3WithSM2Signer(String accessKey, byte[] privateKey) {
        this(accessKey, () -> privateKey);
    }

    private SM3WithSM2Signer(String accessKey, Supplier<byte[]> privateKeySpecSupplier) {
        super(accessKey, null);
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            this.privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeySpecSupplier.get()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException("\u521d\u59cb\u5316 SM3WithSM2Signer \u51fa\u9519", ex);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    @Deprecated
    public String sign(String key, String stringToSign) {
        return this.sign(stringToSign);
    }

    @Override
    public String sign(String stringToSign) {
        byte[] sign = SmUtil.sm2((PrivateKey)this.getPrivateKey(), null).sign(stringToSign.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().encodeToString(sign);
    }
}

