/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SignerHttpRequestInterceptor.class);
    private final Signer signer;

    public SignerHttpRequestInterceptor(Signer signer) {
        this.signer = signer;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (context.getAttribute("signer.skip") != null) {
            log.debug("\u6839\u636e\u914d\u7f6e\u8df3\u8fc7\u7b7e\u540d\u6b65\u9aa4: {}", (Object)request);
            return;
        }
        if (request instanceof HttpUriRequest) {
            this.sign((HttpUriRequest)request, context);
        } else {
            log.debug("Not HttpUriRequest, skip sign the request: {}", (Object)request);
        }
    }

    protected void sign(HttpUriRequest request, HttpContext context) throws HttpException, IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        this.extractContentType(request);
        this.extractParameters(request, params);
        Arrays.stream(request.getAllHeaders()).forEach(header -> headers.put(header.getName(), header.getValue()));
        Optional<String> contentHashOpt = Optional.ofNullable(request.getFirstHeader(Signer.HEADER_NAME_CONTENT_HASH)).map(NameValuePair::getValue);
        log.debug("\u662f\u5426\u9700\u8981\u8ba1\u7b97\u5185\u5bb9\u7684\u54c8\u5e0c\uff1a{}", (Object)(!contentHashOpt.isPresent() ? 1 : 0));
        String contentHash = contentHashOpt.isPresent() ? contentHashOpt.get() : this.calculateContentHash(request);
        String authorization = this.signer.buildAuthorization(request.getMethod(), request.getURI().getPath(), headers, params, contentHash);
        log.debug("Auth\uff1a{}", (Object)authorization);
        request.setHeader("Authorization", authorization);
    }

    private void extractContentType(HttpUriRequest request) {
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Content-Type")) {
            String value;
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            Header contentType = entity != null ? entity.getContentType() : null;
            String string = value = contentType != null ? contentType.getValue() : null;
            if (value != null) {
                request.addHeader(contentType);
            }
        }
    }

    private void extractParameters(HttpUriRequest request, Map<String, String> params) throws IOException {
        HttpEntity entity;
        List list = URLEncodedUtils.parse((URI)request.getURI(), (Charset)StandardCharsets.UTF_8);
        for (NameValuePair pair : list) {
            params.put(pair.getName(), pair.getValue());
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) instanceof UrlEncodedFormEntity) {
            List list2 = URLEncodedUtils.parse((HttpEntity)entity);
            for (NameValuePair pair : list2) {
                params.put(pair.getName(), pair.getValue());
            }
        }
    }

    private String calculateContentHash(HttpUriRequest request) throws IOException {
        HttpEntity entity;
        InputStream content = null;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            if (!entity.isRepeatable()) {
                log.debug("Entity is not repeatable, create buffered entity.");
                entity = new BufferedHttpEntity(entity);
                ((HttpEntityEnclosingRequest)request).setEntity(entity);
            }
            content = entity.getContent();
        }
        return this.signer.hash(content);
    }
}

