/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.tablediff;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Consumer;
import org.opoo.tools.tablediff.Columns;
import org.opoo.tools.tablediff.Id;
import org.opoo.tools.tablediff.Observer;
import org.opoo.tools.tablediff.Table;
import org.opoo.tools.tablediff.TableDiffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableDiffer
implements TableDiffer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableDiffer.class);

    @Override
    public void diff(Table table1, Table table2, Columns columns, Observer observer) throws SQLException {
        try (Connection conn1 = table1.getDataSource().getConnection();
             Connection conn2 = table2.getDataSource().getConnection();
             Statement stmt1 = this.createStatement(conn1);
             Statement stmt2 = this.createStatement(conn2);
             ResultSet rs1 = stmt1.executeQuery(this.buildSql(table1.getName(), columns));
             ResultSet rs2 = stmt2.executeQuery(this.buildSql(table2.getName(), columns));){
            Context context = new Context();
            Status status = null;
            while (status == Status.CONTINUE || status == null) {
                status = this.compare(context, rs1, rs2, columns, observer);
            }
        }
    }

    protected Statement createStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected String buildSql(String tableName, Columns columns) {
        String pkNamesJoinString = String.join((CharSequence)", ", columns.getPkNames());
        return "SELECT " + pkNamesJoinString + ", " + String.join((CharSequence)", ", columns.getNames()) + " FROM " + tableName + " ORDER BY " + pkNamesJoinString;
    }

    protected Status compare(Context context, ResultSet rs1, ResultSet rs2, Columns columns, Observer observer) throws SQLException {
        Id id2;
        Id id1 = context.id1 == null ? this.getNextId(rs1, columns) : context.id1;
        Id id = id2 = context.id2 == null ? this.getNextId(rs2, columns) : context.id2;
        if (id1 == null && id2 == null) {
            return Status.FINISHED;
        }
        log.debug("id1 = {}, id2 = {}", (Object)id1, (Object)id2);
        if (id1 == null) {
            observer.updateOnlyIn2(id2);
            this.addRemainIds(rs2, columns, observer::updateOnlyIn2);
            return Status.FINISHED;
        }
        if (id2 == null) {
            observer.updateOnlyIn1(id1);
            this.addRemainIds(rs1, columns, observer::updateOnlyIn1);
            return Status.FINISHED;
        }
        int compareTo = id1.compareTo(id2);
        if (compareTo < 0) {
            observer.updateOnlyIn1(id1);
            context.update(null, id2);
        } else if (compareTo > 0) {
            observer.updateOnlyIn2(id2);
            context.update(id1, null);
        } else {
            if (this.equals(rs1, rs2, id1, columns)) {
                observer.updateIdentical(id1);
            } else {
                observer.updateDifferent(id1);
            }
            context.update(null, null);
        }
        return Status.CONTINUE;
    }

    protected Id getNextId(ResultSet resultSet, Columns columns) throws SQLException {
        if (resultSet.next()) {
            String[] pkNames = columns.getPkNames();
            String[] id = new String[pkNames.length];
            for (int i = 0; i < pkNames.length; ++i) {
                id[i] = resultSet.getString(pkNames[i]);
            }
            return new Id(id);
        }
        return null;
    }

    protected void addRemainIds(ResultSet rs, Columns columns, Consumer<Id> idConsumer) throws SQLException {
        Id nextId;
        while ((nextId = this.getNextId(rs, columns)) != null) {
            idConsumer.accept(nextId);
        }
    }

    protected boolean equals(ResultSet rs1, ResultSet rs2, Id id, Columns columns) throws SQLException {
        for (String name : columns.getNames()) {
            String va12;
            String val1 = rs1.getString(name);
            if (Objects.equals(val1, va12 = rs2.getString(name))) continue;
            log.info("Difference found: id = {}, column name = '{}', value1 ='{}', value2 = '{}'", new Object[]{id, name, val1, va12});
            return false;
        }
        return true;
    }

    protected static enum Status {
        FINISHED,
        CONTINUE;

    }

    protected static class Context {
        private Id id1;
        private Id id2;

        public void update(Id id1, Id id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public Id getId1() {
            return this.id1;
        }

        public Id getId2() {
            return this.id2;
        }

        public void setId1(Id id1) {
            this.id1 = id1;
        }

        public void setId2(Id id2) {
            this.id2 = id2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Id this$id1 = this.getId1();
            Id other$id1 = other.getId1();
            if (this$id1 == null ? other$id1 != null : !((Object)this$id1).equals(other$id1)) {
                return false;
            }
            Id this$id2 = this.getId2();
            Id other$id2 = other.getId2();
            return !(this$id2 == null ? other$id2 != null : !((Object)this$id2).equals(other$id2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Id $id1 = this.getId1();
            result = result * 59 + ($id1 == null ? 43 : ((Object)$id1).hashCode());
            Id $id2 = this.getId2();
            result = result * 59 + ($id2 == null ? 43 : ((Object)$id2).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTableDiffer.Context(id1=" + this.getId1() + ", id2=" + this.getId2() + ")";
        }
    }
}

