package org.opoo.ootp.signer;

/**
 * 国密算法的签名。
 */
public class SM3SignerV2 extends SM3Signer {
    public static final String EMPTY_BODY_SM3 = "1ab21d8355cfa17f8e61194831e81a8f22bec8c728fefb747ed035eb5082aa2b";
    public static final String ALGORITHM = "HMAC-SM3-V2";

    public SM3SignerV2(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    protected String getEmptyBodySm3() {
        return EMPTY_BODY_SM3;
    }

}
