/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.signer;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.opoo.ootp.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSigner
implements Signer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSigner.class);
    public static String ISO8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static DateTimeFormatter GMT = DateTimeFormatter.ofPattern(ISO8601_FORMAT).withZone(ZoneId.of("GMT"));
    private final String accessKey;
    private final String secretKey;

    public AbstractSigner(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    protected abstract String getAlgorithm();

    @Override
    public String buildAuthorization(String httpMethod, String resourcePath, Map<String, String> headers, Map<String, String> parameters, String contentHash) {
        String dateString = GMT.format(Instant.now());
        String stringToSign = this.buildStringToSign(this.getAlgorithm(), dateString, httpMethod, resourcePath, headers, parameters, contentHash);
        log.debug("StringToSign: [{}]", (Object)stringToSign);
        String signature = this.sign(stringToSign);
        return SCHEME + "-" + this.getAlgorithm() + " " + this.accessKey + ":" + dateString + ":" + signature;
    }

    public String buildStringToSign(String algorithm, String dateTime, String httpMethod, String resourcePath, Map<String, String> headers, Map<String, String> parameters, String contentHash) {
        return SCHEME + "-" + algorithm + "\n" + dateTime + "\n" + httpMethod + "\n" + resourcePath + "\n" + this.getCanonicalizedHeaderString(headers) + "\n" + this.getCanonicalizedQueryString(parameters) + "\n" + contentHash;
    }

    public String getCanonicalizedHeaderString(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        return headers.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(((String)entry.getKey()).toLowerCase(), entry.getValue())).filter(entry -> "content-type".equalsIgnoreCase((String)entry.getKey()) || ((String)entry.getKey()).startsWith(HEADER_NAME_PREFIX)).sorted(Map.Entry.comparingByKey()).map(entry -> ((String)entry.getKey()).replaceAll("\\s+", " ") + ":" + ((String)entry.getValue()).replaceAll("\\s+", " ") + "\n").collect(Collectors.joining(""));
    }

    public String getCanonicalizedQueryString(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        return parameters.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }
}

