/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.ColumnValueExtractor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class Table {
    private final String name;
    private final Column[] columns;
    private String whereClause;
    private ColumnValueExtractor columnValueExtractor;
    private final Map<String, Column> columnsMap = new LinkedCaseInsensitiveMap();
    private final List<Column> primaryKeyColumns;
    private final List<Column> normalColumns;

    public Table(String name, Column ... columns) {
        this.name = name;
        this.columns = columns;
        Assert.isTrue((columns.length > 0 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u6570\u5fc5\u987b\u5927\u4e8e 0");
        ArrayList<Column> pkColumns = new ArrayList<Column>();
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (Column column : columns) {
            this.columnsMap.put(column.getName(), column);
            if (column.isPrimaryKey()) {
                pkColumns.add(column);
                continue;
            }
            columnList.add(column);
        }
        this.primaryKeyColumns = Collections.unmodifiableList(pkColumns);
        this.normalColumns = Collections.unmodifiableList(columnList);
        Assert.isTrue((!this.primaryKeyColumns.isEmpty() ? 1 : 0) != 0, (String)"\u4e3b\u952e\u5b57\u6bb5\u6570\u5fc5\u987b\u5927\u4e8e 0");
    }

    public Table withColumnValueExtractor(ColumnValueExtractor columnValueExtractor) {
        this.columnValueExtractor = columnValueExtractor;
        return this;
    }

    public Table withWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public ColumnValueExtractor getColumnValueExtractor() {
        return this.columnValueExtractor;
    }

    public Map<String, Column> getColumnsMap() {
        return this.columnsMap;
    }

    public List<Column> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<Column> getNormalColumns() {
        return this.normalColumns;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setColumnValueExtractor(ColumnValueExtractor columnValueExtractor) {
        this.columnValueExtractor = columnValueExtractor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        String this$whereClause = this.getWhereClause();
        String other$whereClause = other.getWhereClause();
        if (this$whereClause == null ? other$whereClause != null : !this$whereClause.equals(other$whereClause)) {
            return false;
        }
        ColumnValueExtractor this$columnValueExtractor = this.getColumnValueExtractor();
        ColumnValueExtractor other$columnValueExtractor = other.getColumnValueExtractor();
        if (this$columnValueExtractor == null ? other$columnValueExtractor != null : !this$columnValueExtractor.equals(other$columnValueExtractor)) {
            return false;
        }
        Map<String, Column> this$columnsMap = this.getColumnsMap();
        Map<String, Column> other$columnsMap = other.getColumnsMap();
        if (this$columnsMap == null ? other$columnsMap != null : !((Object)this$columnsMap).equals(other$columnsMap)) {
            return false;
        }
        List<Column> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<Column> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        if (this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns)) {
            return false;
        }
        List<Column> this$normalColumns = this.getNormalColumns();
        List<Column> other$normalColumns = other.getNormalColumns();
        return !(this$normalColumns == null ? other$normalColumns != null : !((Object)this$normalColumns).equals(other$normalColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        String $whereClause = this.getWhereClause();
        result = result * 59 + ($whereClause == null ? 43 : $whereClause.hashCode());
        ColumnValueExtractor $columnValueExtractor = this.getColumnValueExtractor();
        result = result * 59 + ($columnValueExtractor == null ? 43 : $columnValueExtractor.hashCode());
        Map<String, Column> $columnsMap = this.getColumnsMap();
        result = result * 59 + ($columnsMap == null ? 43 : ((Object)$columnsMap).hashCode());
        List<Column> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        List<Column> $normalColumns = this.getNormalColumns();
        result = result * 59 + ($normalColumns == null ? 43 : ((Object)$normalColumns).hashCode());
        return result;
    }

    public String toString() {
        return "Table(name=" + this.getName() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", whereClause=" + this.getWhereClause() + ", columnValueExtractor=" + this.getColumnValueExtractor() + ")";
    }
}

