/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.diff.table;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.opoo.tools.db.Id;

public class Result {
    private final String tableNameA;
    private final String tableNameB;
    private final List<Id> idsOnlyInA;
    private final List<Id> idsOnlyInB;
    private final List<Id> idsDifferent;
    private long identicalRecordCount = 0L;

    public Result(String tableNameA, String tableNameB) {
        this(tableNameA, tableNameB, () -> new IdList());
    }

    private Result(String tableNameA, String tableNameB, Supplier<List<Id>> idListBuilder) {
        this.tableNameA = tableNameA;
        this.tableNameB = tableNameB;
        this.idsOnlyInA = idListBuilder.get();
        this.idsOnlyInB = idListBuilder.get();
        this.idsDifferent = idListBuilder.get();
    }

    public static Result arrayListResult(String tableNameA, String tableNameB) {
        return new Result(tableNameA, tableNameB, ArrayList::new);
    }

    public void incrementIdenticalRecordCount() {
        ++this.identicalRecordCount;
    }

    public String getTableNameA() {
        return this.tableNameA;
    }

    public String getTableNameB() {
        return this.tableNameB;
    }

    public List<Id> getIdsOnlyInA() {
        return this.idsOnlyInA;
    }

    public List<Id> getIdsOnlyInB() {
        return this.idsOnlyInB;
    }

    public List<Id> getIdsDifferent() {
        return this.idsDifferent;
    }

    public long getIdenticalRecordCount() {
        return this.identicalRecordCount;
    }

    public String toString() {
        return "Result(tableNameA=" + this.getTableNameA() + ", tableNameB=" + this.getTableNameB() + ", idsOnlyInA=" + this.getIdsOnlyInA() + ", idsOnlyInB=" + this.getIdsOnlyInB() + ", idsDifferent=" + this.getIdsDifferent() + ", identicalRecordCount=" + this.getIdenticalRecordCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIdenticalRecordCount() != other.getIdenticalRecordCount()) {
            return false;
        }
        String this$tableNameA = this.getTableNameA();
        String other$tableNameA = other.getTableNameA();
        if (this$tableNameA == null ? other$tableNameA != null : !this$tableNameA.equals(other$tableNameA)) {
            return false;
        }
        String this$tableNameB = this.getTableNameB();
        String other$tableNameB = other.getTableNameB();
        if (this$tableNameB == null ? other$tableNameB != null : !this$tableNameB.equals(other$tableNameB)) {
            return false;
        }
        List<Id> this$idsOnlyInA = this.getIdsOnlyInA();
        List<Id> other$idsOnlyInA = other.getIdsOnlyInA();
        if (this$idsOnlyInA == null ? other$idsOnlyInA != null : !((Object)this$idsOnlyInA).equals(other$idsOnlyInA)) {
            return false;
        }
        List<Id> this$idsOnlyInB = this.getIdsOnlyInB();
        List<Id> other$idsOnlyInB = other.getIdsOnlyInB();
        if (this$idsOnlyInB == null ? other$idsOnlyInB != null : !((Object)this$idsOnlyInB).equals(other$idsOnlyInB)) {
            return false;
        }
        List<Id> this$idsDifferent = this.getIdsDifferent();
        List<Id> other$idsDifferent = other.getIdsDifferent();
        return !(this$idsDifferent == null ? other$idsDifferent != null : !((Object)this$idsDifferent).equals(other$idsDifferent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $identicalRecordCount = this.getIdenticalRecordCount();
        result = result * 59 + (int)($identicalRecordCount >>> 32 ^ $identicalRecordCount);
        String $tableNameA = this.getTableNameA();
        result = result * 59 + ($tableNameA == null ? 43 : $tableNameA.hashCode());
        String $tableNameB = this.getTableNameB();
        result = result * 59 + ($tableNameB == null ? 43 : $tableNameB.hashCode());
        List<Id> $idsOnlyInA = this.getIdsOnlyInA();
        result = result * 59 + ($idsOnlyInA == null ? 43 : ((Object)$idsOnlyInA).hashCode());
        List<Id> $idsOnlyInB = this.getIdsOnlyInB();
        result = result * 59 + ($idsOnlyInB == null ? 43 : ((Object)$idsOnlyInB).hashCode());
        List<Id> $idsDifferent = this.getIdsDifferent();
        result = result * 59 + ($idsDifferent == null ? 43 : ((Object)$idsDifferent).hashCode());
        return result;
    }

    private static class IdList
    extends ArrayList<Id> {
        private IdList() {
        }

        @Override
        public String toString() {
            return String.valueOf(this.size());
        }
    }
}

