/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.diff.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.Id;
import org.opoo.tools.db.SqlEqualizer;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.TableInput;
import org.opoo.tools.db.diff.table.Listener;
import org.opoo.tools.db.diff.table.TableComparator;
import org.opoo.tools.db.util.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SimpleTableComparator
implements TableComparator {
    private static final Logger log = LoggerFactory.getLogger(SimpleTableComparator.class);

    @Override
    public void compare(TableInput tableInputA, TableInput tableInputB, SqlEqualizer<ResultSet> equalizer, Listener listener) throws SQLException {
        Table tableA = tableInputA.getTable();
        Table tableB = tableInputB.getTable();
        if (tableA.getColumns().length != tableB.getColumns().length || tableA.getPrimaryKeyColumns().size() != tableB.getPrimaryKeyColumns().size()) {
            throw new IllegalArgumentException("Tables must have the same number of columns");
        }
        try (PreparedStatement psA = this.preparedStatement(tableA, tableInputA.getConnection());
             PreparedStatement psB = this.preparedStatement(tableB, tableInputB.getConnection());
             ResultSet rsA = psA.executeQuery();
             ResultSet rsB = psB.executeQuery();){
            Context context = this.createContext(tableA, tableB, rsA, rsB);
            Status status = Status.CONTINUE;
            while (status == Status.CONTINUE) {
                status = this.compareInternal(context, equalizer, listener);
            }
        }
    }

    protected Context createContext(Table tableA, Table tableB, ResultSet rsA, ResultSet rsB) throws SQLException {
        DbUtils.initializeColumnTypes(tableA, rsA);
        DbUtils.initializeColumnTypes(tableB, rsB);
        return new Context(tableA, tableB, rsA, rsB).moveNext();
    }

    protected PreparedStatement preparedStatement(Table table, Connection conn) throws SQLException {
        String sql = this.buildSql(table);
        log.debug("Executing query: {}", (Object)sql);
        return this.preparedStatement(conn, sql);
    }

    protected String buildSql(Table table) {
        StringBuilder stringBuilder = new StringBuilder();
        String primaryKeysJoinString = table.getPrimaryKeyColumns().stream().map(Column::getName).collect(Collectors.joining(", "));
        String columnsJoinString = table.getNormalColumns().stream().map(Column::getName).collect(Collectors.joining(", "));
        stringBuilder.append("SELECT ").append(primaryKeysJoinString).append(", ").append(columnsJoinString).append(" FROM ").append(table.getName());
        if (StringUtils.hasText((String)table.getWhereClause())) {
            stringBuilder.append(" WHERE ").append(table.getWhereClause());
        }
        stringBuilder.append(" ORDER BY ").append(primaryKeysJoinString);
        return stringBuilder.toString();
    }

    protected PreparedStatement preparedStatement(Connection conn, String sql) throws SQLException {
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        String databaseProductName = databaseMetaData.getDatabaseProductName();
        PreparedStatement ps = conn.prepareStatement(sql, 1003, 1007);
        if (databaseProductName.startsWith("Oracle")) {
            ps.setFetchSize(10000);
        } else if (databaseProductName.startsWith("MySQL") || databaseProductName.startsWith("MariaDB")) {
            ps.setFetchSize(Integer.MIN_VALUE);
        }
        return ps;
    }

    protected Status compareInternal(Context context, SqlEqualizer<ResultSet> equalizer, Listener listener) throws SQLException {
        Id idA = context.getIdA();
        Id idB = context.getIdB();
        if (idA == null && idB == null) {
            return Status.FINISHED;
        }
        log.debug("Comparing idA = {}, idB = {}", (Object)idA, (Object)idB);
        if (idA == null) {
            listener.onOnlyInB(idB);
            while (context.nextIdB()) {
                listener.onOnlyInB(context.getIdB());
            }
            return Status.FINISHED;
        }
        if (idB == null) {
            listener.onOnlyInA(idA);
            while (context.nextIdA()) {
                listener.onOnlyInA(context.getIdA());
            }
            return Status.FINISHED;
        }
        int compareTo = idA.compareTo(idB);
        if (compareTo < 0) {
            listener.onOnlyInA(idA);
            context.nextIdA();
            return Status.CONTINUE;
        }
        if (compareTo > 0) {
            listener.onOnlyInB(idB);
            context.nextIdB();
            return Status.CONTINUE;
        }
        this.compareNormalColumns(context, idA, equalizer, listener);
        return Status.CONTINUE;
    }

    protected void compareNormalColumns(Context context, Id id, SqlEqualizer<ResultSet> equalizer, Listener listener) throws SQLException {
        boolean isNormalColumnsEqual = equalizer != null ? equalizer.equals(context.getResultSetA(), context.getResultSetB()) : this.isNormalColumnsEqual(context);
        if (isNormalColumnsEqual) {
            listener.onIdentical(id);
        } else {
            listener.onDifferent(id);
        }
        context.moveNext();
    }

    protected boolean isNormalColumnsEqual(Context context) throws SQLException {
        Table tableA = context.getTableA();
        Table tableB = context.getTableB();
        List<Column> normalColumnsA = tableA.getNormalColumns();
        List<Column> normalColumnsB = tableB.getNormalColumns();
        for (int i = 0; i < normalColumnsA.size(); ++i) {
            Object valueB;
            Column columnA = normalColumnsA.get(i);
            Column columnB = normalColumnsB.get(i);
            Object valueA = DbUtils.extractValue(tableA, columnA, context.getResultSetA());
            if (Objects.equals(valueA, valueB = DbUtils.extractValue(tableB, columnB, context.getResultSetB()))) continue;
            log.info("Difference found: id = {}, tableA column name = '{}', valueA ='{}', tableB column name = '{}', valueB = '{}'", new Object[]{context.getIdA(), columnA.getName(), valueA, columnB.getName(), valueB});
            return false;
        }
        return true;
    }

    protected static enum Status {
        FINISHED,
        CONTINUE;

    }

    protected static class Context {
        private final Table tableA;
        private final Table tableB;
        private final ResultSet resultSetA;
        private final ResultSet resultSetB;
        private Id idA;
        private Id idB;

        protected Context moveNext() throws SQLException {
            this.nextIdA();
            this.nextIdB();
            return this;
        }

        protected boolean nextIdA() throws SQLException {
            this.idA = DbUtils.getNextId(this.tableA, this.resultSetA);
            return this.idA != null;
        }

        protected boolean nextIdB() throws SQLException {
            this.idB = DbUtils.getNextId(this.tableB, this.resultSetB);
            return this.idB != null;
        }

        public Context(Table tableA, Table tableB, ResultSet resultSetA, ResultSet resultSetB) {
            this.tableA = tableA;
            this.tableB = tableB;
            this.resultSetA = resultSetA;
            this.resultSetB = resultSetB;
        }

        public Table getTableA() {
            return this.tableA;
        }

        public Table getTableB() {
            return this.tableB;
        }

        public ResultSet getResultSetA() {
            return this.resultSetA;
        }

        public ResultSet getResultSetB() {
            return this.resultSetB;
        }

        public Id getIdA() {
            return this.idA;
        }

        public Id getIdB() {
            return this.idB;
        }

        public void setIdA(Id idA) {
            this.idA = idA;
        }

        public void setIdB(Id idB) {
            this.idB = idB;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Table this$tableA = this.getTableA();
            Table other$tableA = other.getTableA();
            if (this$tableA == null ? other$tableA != null : !((Object)this$tableA).equals(other$tableA)) {
                return false;
            }
            Table this$tableB = this.getTableB();
            Table other$tableB = other.getTableB();
            if (this$tableB == null ? other$tableB != null : !((Object)this$tableB).equals(other$tableB)) {
                return false;
            }
            ResultSet this$resultSetA = this.getResultSetA();
            ResultSet other$resultSetA = other.getResultSetA();
            if (this$resultSetA == null ? other$resultSetA != null : !this$resultSetA.equals(other$resultSetA)) {
                return false;
            }
            ResultSet this$resultSetB = this.getResultSetB();
            ResultSet other$resultSetB = other.getResultSetB();
            if (this$resultSetB == null ? other$resultSetB != null : !this$resultSetB.equals(other$resultSetB)) {
                return false;
            }
            Id this$idA = this.getIdA();
            Id other$idA = other.getIdA();
            if (this$idA == null ? other$idA != null : !((Object)this$idA).equals(other$idA)) {
                return false;
            }
            Id this$idB = this.getIdB();
            Id other$idB = other.getIdB();
            return !(this$idB == null ? other$idB != null : !((Object)this$idB).equals(other$idB));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Table $tableA = this.getTableA();
            result = result * 59 + ($tableA == null ? 43 : ((Object)$tableA).hashCode());
            Table $tableB = this.getTableB();
            result = result * 59 + ($tableB == null ? 43 : ((Object)$tableB).hashCode());
            ResultSet $resultSetA = this.getResultSetA();
            result = result * 59 + ($resultSetA == null ? 43 : $resultSetA.hashCode());
            ResultSet $resultSetB = this.getResultSetB();
            result = result * 59 + ($resultSetB == null ? 43 : $resultSetB.hashCode());
            Id $idA = this.getIdA();
            result = result * 59 + ($idA == null ? 43 : ((Object)$idA).hashCode());
            Id $idB = this.getIdB();
            result = result * 59 + ($idB == null ? 43 : ((Object)$idB).hashCode());
            return result;
        }

        public String toString() {
            return "SimpleTableComparator.Context(tableA=" + this.getTableA() + ", tableB=" + this.getTableB() + ", resultSetA=" + this.getResultSetA() + ", resultSetB=" + this.getResultSetB() + ", idA=" + this.getIdA() + ", idB=" + this.getIdB() + ")";
        }
    }
}

