/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.ColumnValueExtractor;
import org.opoo.tools.db.Id;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.ValueExtractor;
import org.opoo.tools.db.util.SqlSupplier;
import org.opoo.tools.db.util.SqlTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);

    public static Id getNextId(Table table, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            List<Column> primaryKeyList = table.getPrimaryKeyColumns();
            ArrayList<Object> idValues = new ArrayList<Object>();
            for (Column column : primaryKeyList) {
                Object value = DbUtils.extractValue(table, column, resultSet);
                idValues.add(value);
            }
            return new Id(idValues.toArray());
        }
        return null;
    }

    public static Object extractValue(Table table, Column column, ResultSet resultSet) throws SQLException {
        ValueExtractor valueExtractor = column.getValueExtractor();
        if (valueExtractor != null) {
            return valueExtractor.extract(resultSet);
        }
        ColumnValueExtractor columnValueExtractor = table.getColumnValueExtractor();
        if (columnValueExtractor != null) {
            return columnValueExtractor.extract(resultSet, column.getName());
        }
        return resultSet.getObject(column.getName(), column.getType());
    }

    public static void initializeColumnTypes(Table table, ResultSet rs) throws SQLException {
        if (table.getColumnValueExtractor() != null) {
            log.debug("\u8868[{}]\u6307\u5b9a\u4e86\u81ea\u5b9a\u4e49\u7684\u5217\u503c\u63d0\u53d6\u5668\uff0c\u4e0d\u5fc5\u81ea\u52a8\u89e3\u6790\u503c\u7c7b\u578b", (Object)table.getName());
            return;
        }
        Column[] columns = table.getColumns();
        boolean allMatch = Arrays.stream(columns).allMatch(c -> Objects.nonNull(c.getType()));
        if (allMatch) {
            return;
        }
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (column.getValueExtractor() != null) {
                log.debug("\u8868[{}]\u5217[{}]\u6307\u5b9a\u4e86\u81ea\u5b9a\u4e49\u4e86\u503c\u63d0\u53d6\u5668\uff0c\u4e0d\u5fc5\u81ea\u52a8\u89e3\u6790\u503c\u7c7b\u578b", (Object)table.getName(), (Object)column.getName());
                continue;
            }
            if (!Objects.isNull(column.getType())) continue;
            int columnType = resultSetMetaData.getColumnType(i + 1);
            Class<?> type = SqlTypeUtils.sqlTypeToClass(columnType);
            column.setType(type);
        }
    }

    public static <T> T orElse(T obj, SqlSupplier<T> supplier) throws SQLException {
        if (obj == null) {
            return supplier.get();
        }
        return obj;
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static Table buildTable(String tableName, Connection conn) throws SQLException {
        return DbUtils.buildTable(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), tableName, conn);
    }

    public static Table buildTable(String catalog, String schemaPattern, String tableName, Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try (ResultSet rs = metaData.getPrimaryKeys(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), tableName);){
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        try (ResultSet columns = metaData.getColumns(catalog, schemaPattern, tableName, null);){
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                boolean isPrimaryKey = primaryKeys.contains(columnName);
                int dataType = columns.getInt("DATA_TYPE");
                Class<?> type = SqlTypeUtils.sqlTypeToClass(dataType);
                Column column = new Column(columnName, isPrimaryKey).withType(type);
                columnList.add(column);
            }
        }
        log.debug("table {}: {}", (Object)tableName, columnList);
        return new Table(tableName, columnList.toArray(new Column[0]));
    }

    public static List<String> getTableNames(Connection conn) throws SQLException {
        return DbUtils.getTableNames(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), "%", conn);
    }

    public static List<String> getTableNames(String catalog, String schemaPattern, String tableNamePattern, Connection conn) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        DatabaseMetaData metaData = conn.getMetaData();
        try (ResultSet tables = metaData.getTables(catalog, schemaPattern, tableNamePattern, new String[]{"TABLE"});){
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        return tableNames;
    }

    private DbUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

