package org.opoo.ootp.signer;

import cn.hutool.crypto.SmUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.function.Supplier;

public class SM3WithSM2Signer extends SM3SignerV2 {
    public static final String ALGORITHM = "SM3withSM2";
    private static final String INVALID_SECRET_KEY = "invalid-secret-key";

    private final PrivateKey privateKey;

    public SM3WithSM2Signer(String accessKey, PrivateKey privateKey) {
        super(accessKey, null);
        this.privateKey = privateKey;
    }

    public SM3WithSM2Signer(String accessKey, String privateKeyBase64) {
        this(accessKey, () -> Base64.getDecoder().decode(privateKeyBase64));
    }

    public SM3WithSM2Signer(String accessKey, byte[] privateKey) {
        this(accessKey, () -> privateKey);
    }

    private SM3WithSM2Signer(String accessKey, Supplier<byte[]> privateKeySpecSupplier) {
        super(accessKey, null);

        final Provider provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
        if (provider == null) {
            Security.addProvider(new BouncyCastleProvider());
        }

        try {
            final KeyFactory keyFactory = KeyFactory.getInstance("EC", BouncyCastleProvider.PROVIDER_NAME);
            this.privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeySpecSupplier.get()));
        } catch (RuntimeException ex) {
            throw ex;
        } catch (Exception ex) {
            throw new SecurityException("初始化 SM3WithSM2Signer 出错", ex);
        }
    }

    public PrivateKey getPrivateKey() {
        return privateKey;
    }

    @Override
    protected String getAlgorithm() {
        return ALGORITHM;
    }

    @Deprecated
    @Override
    public String sign(String key, String stringToSign) {
        return sign(stringToSign);
    }

    @Override
    public String sign(String stringToSign) {
        final byte[] sign = SmUtil.sm2(getPrivateKey(), null).sign(stringToSign.getBytes(StandardCharsets.UTF_8));
        //return Hex.encodeHexString(sign);
        return Base64.getUrlEncoder().encodeToString(sign);
    }
}
