package org.opoo.tools.db;

import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

/**
 * 参数设置器。
 */
public class ArgumentSetter extends ArgumentPreparedStatementSetter {
    private final List<Object> args;

    public ArgumentSetter(List<Object> args) {
        super(null);
        this.args = args;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        super.setValues(ps);
        if (args != null) {
            for (int i = 0; i < this.args.size(); i++) {
                Object arg = args.get(i);
                doSetValue(ps, i + 1, arg);
            }
        }
    }
}
