package org.opoo.tools.db;

import lombok.Data;
import lombok.ToString;
import org.springframework.jdbc.support.JdbcUtils;

@Data
public class Column {
    /**
     * 字段名，或者表达式，用于复制的目标表时通常不能是表达式。
     */
    private final String name;
    /**
     * 字段是否是主键。
     */
    private final boolean primaryKey;

    /**
     * 字段的 Java 类型，在对比表数据或者读取字段的值时使用。不指定时程序自动判断。
     */
    private Class<?> type;
    /**
     * 字段的 SQL 类型，见 {@link java.sql.Types}，一般用于数据写入（数据复制的场景）。不指定时程序自动判断类型。
     */
    private int sqlType = JdbcUtils.TYPE_UNKNOWN;

    @ToString.Exclude
    private transient Table table;

    public Column(String name) {
        this.name = name;
        this.primaryKey = false;
    }

    public Column(String name, boolean primaryKey) {
        this.name = name;
        this.primaryKey = primaryKey;
    }

    public Column withType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Column withSqlType(int sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    void setTable(Table table) {
        this.table = table;
    }
}
