package org.opoo.tools.db;

import lombok.EqualsAndHashCode;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

@Getter
@EqualsAndHashCode
public class Id implements Comparable<Id> {
    private final Object[] values;

    public Id(Object... values) {
        for (Object value : values) {
            if (!(value instanceof Comparable)) {
                throw new IllegalArgumentException("id value must be comparable");
            }
        }
        this.values = values;
    }

    @Override
    public String toString() {
        return Arrays.toString(values);
    }

    @Override
    @SuppressWarnings({"rawtypes", "unchecked"})
    public int compareTo(Id id) {
        Objects.requireNonNull(id, "id must not be null");

        if (id == this) {
            return 0;
        }

        if (id.values.length != values.length) {
            throw new IllegalArgumentException("id lengths do not match");
        }

        for (int i = 0; i < values.length; i++) {
            final int result = ((Comparable) values[i]).compareTo(id.values[i]);
            if (result != 0) {
                return result;
            }
            // 相等则比下一个
        }

        return 0;
    }
}
