package org.opoo.tools.db.copy;

import lombok.Setter;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.Table;

@Setter
public class MySQLTableCopier extends SimpleTableCopier {
    private boolean usingOnDuplicateKeyUpdate = false;

    @Override
    protected String buildInsertSql(Table sourceTable, Table targetTable) {
        final String sql = super.buildInsertSql(sourceTable, targetTable);
        if (!usingOnDuplicateKeyUpdate) {
            return sql;
        }

        final StringBuilder stringBuilder = new StringBuilder(sql).append(" as n ON DUPLICATE KEY UPDATE ");
        final Column[] normalColumns2 = targetTable.getNormalColumns();
        for (int i = 0; i < normalColumns2.length; i++) {
            stringBuilder.append(normalColumns2[i].getName()).append(" = n.").append(normalColumns2[i].getName());
            if (i < normalColumns2.length - 1) {
                stringBuilder.append(", ");
            }
        }

        return stringBuilder.toString();
    }
}
