package org.opoo.tools.db.copy;

import org.opoo.tools.db.Table;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * 同库数据表复制。表现为同一个连接（数据源）。
 */
public interface SameDbTableCopier {

    /**
     * 同库复制表。
     *
     * @param connection  连接
     * @param sourceTable 源表
     * @param targetTable 目标表
     * @param batchSize   批次大小
     * @return 复制数量
     * @throws SQLException 复制过程出现的异常
     */
    int copy(Connection connection, Table sourceTable, Table targetTable, int batchSize) throws SQLException;
}
