package org.opoo.tools.db.copy;

import org.opoo.tools.db.SqlBiConsumer;
import org.opoo.tools.db.TableInput;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 表复制。从一个数据源复制到另外一个数据源。两个数据源也可以相同。
 */
public interface TableCopier {

    /**
     * 从源表复制数据到目标表。
     *
     * @param source    源
     * @param target    目标
     * @param batchSize 批次大小
     * @return 复制的记录数量
     * @throws SQLException 复制过程可能出现的SQL异常，复制程序不捕捉任何 SQL 异常
     */
    default int copy(TableInput source, TableInput target, int batchSize) throws SQLException {
        return copy(source, target, batchSize, null);
    }

    /**
     * 从源表复制数据到目标表。
     *
     * @param source       源
     * @param target       目标
     * @param batchSize    批次大小
     * @param recordCopier 自定的记录复制处理器，主要作用是将一条记录从 {@link  ResultSet} 复制到 {@link PreparedStatement} 对象
     * @return 复制的记录数量
     * @throws SQLException 复制过程可能出现的SQL异常，复制程序不捕捉任何 SQL 异常
     */
    int copy(TableInput source, TableInput target, int batchSize, SqlBiConsumer<ResultSet, PreparedStatement> recordCopier) throws SQLException;
}
