package org.opoo.tools.db.diff;

import org.opoo.tools.db.DatabaseInput;

import java.sql.SQLException;

/**
 * 数据库对比。
 */
public interface DatabaseComparator {
    /**
     * 比对2个库。
     *
     * @param dbA      数据库A
     * @param dbB      数据库B
     * @param listener 比对结果监听器
     * @throws SQLException SQL异常
     */
    void compare(DatabaseInput dbA, DatabaseInput dbB, DatabaseListener listener) throws SQLException;
}
