package org.opoo.tools.db.diff;

/**
 * 数据库对比结果监听器。
 */
public interface DatabaseListener {
    /**
     * 仅在A库存在的表的表名。
     */
    void onOnlyInDbA(String tableName);

    /**
     * 仅在B库存在的表的表名。
     */
    void onOnlyInDbB(String tableName);

    /**
     * 两个库中存在相同的表，且的这个表的数据完全一致时触发的监听方法。
     */
    void onIdentical(String tableName);

    /**
     * 两个库中存在相同的表，且比对数据不一致时触发的监听方法。
     *
     * @param tableName 表名
     * @param result    表的比对结果
     */
    void onTableDifferent(String tableName, TableResult result);

    /**
     * 两个库中存在相同的表，且对比出错时触发的监听方法。
     *
     * @param tableName 表名
     * @param e         异常
     */
    void onTableException(String tableName, Exception e);
}
