package org.opoo.tools.db.diff;

import org.opoo.tools.db.Id;

/**
 * 对比结果的监听器，实现类可以将结果写到数据库或者文件。
 */
public interface TableListener {

    /**
     * 比对发现仅在A库存在的记录触发该方法。
     */
    void onOnlyInA(Id id);

    /**
     * 比对发现仅在B库存在的记录触发该方法。
     */
    void onOnlyInB(Id id);

    /**
     * 比对结果两边的记录相同时触发该方法。
     */
    void onIdentical(Id id);

    /**
     * 比对结果两表的记录主键相同，非主键字段不同时触发该方法。
     */
    void onDifferent(Id id);
}
