package org.opoo.tools.db.diff;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;
import org.opoo.tools.db.Id;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

@Getter
@ToString
@EqualsAndHashCode
public class TableResult {
    private final String tableNameA;
    private final String tableNameB;

    private final List<Id> idsOnlyInA;
    private final List<Id> idsOnlyInB;
    private final List<Id> idsDifferent;
    private long identicalRecordCount = 0;

    public TableResult(String tableNameA, String tableNameB) {
        this(tableNameA, tableNameB, IdList::new);
    }

    private TableResult(String tableNameA, String tableNameB, Supplier<List<Id>> idListBuilder) {
        this.tableNameA = tableNameA;
        this.tableNameB = tableNameB;
        this.idsOnlyInA = idListBuilder.get();
        this.idsOnlyInB = idListBuilder.get();
        this.idsDifferent = idListBuilder.get();
    }

    public static TableResult arrayListResult(String tableNameA, String tableNameB) {
        return new TableResult(tableNameA, tableNameB, ArrayList::new);
    }

    public void incrementIdenticalRecordCount() {
        identicalRecordCount++;
    }

    private static class IdList extends ArrayList<Id> {
        @Override
        public String toString() {
            return String.valueOf(size());
        }
    }
}
