package org.opoo.tools.db.diff;

import lombok.Getter;
import org.opoo.tools.db.Id;

@Getter
public class TableResultListener implements TableListener {
    private final TableResult result;

    public TableResultListener(TableResult result) {
        this.result = result;
    }

    public TableResultListener(String tableNameA, String tableNameB) {
        this.result = new TableResult(tableNameA, tableNameB);
    }

    @Override
    public void onOnlyInA(Id id) {
        result.getIdsOnlyInA().add(id);
    }

    @Override
    public void onOnlyInB(Id id) {
        result.getIdsOnlyInB().add(id);
    }

    @Override
    public void onIdentical(Id id) {
        result.incrementIdenticalRecordCount();
    }

    @Override
    public void onDifferent(Id id) {
        result.getIdsDifferent().add(id);
    }
}
