package org.opoo.tools.db.util;


import java.util.ArrayList;
import java.util.List;

public class ListUtils {

    public static List<String> removeAllIgnoreCase(List<String> list, List<String> removing) {
        final List<String> result = new ArrayList<>();
        for (String s : list) {
            final boolean anyMatch = removing.stream().anyMatch(s::equalsIgnoreCase);
            if (!anyMatch) {
                result.add(s);
            }
        }
        return result;
    }

    public static List<String> intersectionIgnoreCase(List<String> list1, List<String> list2) {
        final List<String> result = new ArrayList<>();
        for (String s : list1) {
            final boolean anyMatch = list2.stream().anyMatch(s::equalsIgnoreCase);
            if (anyMatch) {
                result.add(s);
            }
        }
        return result;
    }
}
