package org.opoo.tools.db.util;

import lombok.experimental.UtilityClass;

import java.math.BigDecimal;
import java.util.Date;

import static java.sql.Types.BIGINT;
import static java.sql.Types.BINARY;
import static java.sql.Types.BLOB;
import static java.sql.Types.BOOLEAN;
import static java.sql.Types.DATE;
import static java.sql.Types.DECIMAL;
import static java.sql.Types.DOUBLE;
import static java.sql.Types.FLOAT;
import static java.sql.Types.INTEGER;
import static java.sql.Types.LONGVARBINARY;
import static java.sql.Types.NUMERIC;
import static java.sql.Types.SMALLINT;
import static java.sql.Types.TIME;
import static java.sql.Types.TIMESTAMP;
import static java.sql.Types.TINYINT;
import static java.sql.Types.VARBINARY;

@UtilityClass
public class SqlTypeUtils {

    public static Class<?> sqlTypeToClass(int sqlType) {
        switch (sqlType) {
            case BOOLEAN:
                return Boolean.class;

            case TINYINT:
            case SMALLINT:
            case INTEGER:
                return Integer.class;

            case BIGINT:
                return Long.class;

            case DECIMAL:
            case NUMERIC:
                return BigDecimal.class;

            case FLOAT:
                return Float.class;

            case DOUBLE:
                return Double.class;

            case DATE:
            case TIME:
            case TIMESTAMP:
                return Date.class;

            case BLOB:
            case LONGVARBINARY:
            case BINARY:
            case VARBINARY:
                return byte[].class;

            default:
                return String.class;
        }
    }

}
