package org.opoo.tools.tablediff;

import lombok.Data;

import java.util.Objects;

@Deprecated
@Data
public class Columns {
    private final String[] pkNames;
    private final String[] names;
    private final Class<?>[] pkTypes;
    private final Class<?>[] types;

    private Columns(String[] pkNames, String[] names, Class<?>[] pkTypes, Class<?>[] types) {
        this.pkNames = pkNames;
        this.names = names;
        this.pkTypes = pkTypes;
        this.types = types;
        validate();
    }

    private void validate() {
        Objects.requireNonNull(pkNames, "pkNames is required");
        Objects.requireNonNull(names, "names is required");
        if (pkTypes != null && pkTypes.length != pkNames.length) {
            throw new IllegalArgumentException("pkTypes.length != pkNames.length");
        }
        if (types != null && types.length != names.length) {
            throw new IllegalArgumentException("columnTypes.length != names.length");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] pkNames;
        private String[] names;
        private Class<?>[] pkTypes;
        private Class<?>[] types;

        public Builder pkNames(String... pkNames) {
            this.pkNames = pkNames;
            return this;
        }

        public Builder names(String... names) {
            this.names = names;
            return this;
        }

        public Builder pkTypes(Class<?>... pkTypes) {
            this.pkTypes = pkTypes;
            return this;
        }

        public Builder types(Class<?>... types) {
            this.types = types;
            return this;
        }

        public Columns build() {
            return new Columns(pkNames, names, pkTypes, types);
        }
    }
}
