package org.opoo.tools.tablediff;

import lombok.Builder;
import lombok.Data;

@Deprecated
@Data
@Builder
public class Comparison {
    /**
     * Table 1
     */
    private Table table1;
    /**
     * Table 2
     */
    private Table table2;
    /**
     * Columns' (primary key and normal columns) name and type.
     */
    private Columns columns;
    /**
     * Optional start id (exclusive).
     */
    private Id startId;

    private Comparison(Table table1, Table table2, Columns columns, Id startId) {
        this.table1 = table1;
        this.table2 = table2;
        this.columns = columns;
        this.startId = startId;
        validate();
    }

    private void validate() {
        if (startId != null) {
            final Object[] startIdValues = startId.getValues();
            if (startIdValues.length != columns.getPkNames().length) {
                throw new IllegalArgumentException("startId and pkNames must have the same length");
            }

            final Class<?>[] pkTypes = columns.getPkTypes();
            if (pkTypes != null) {
                for (int i = 0; i < startIdValues.length; i++) {
                    if (!pkTypes[i].isInstance(startIdValues[i])) {
                        throw new IllegalArgumentException("startId 数据类型不匹配");
                    }
                }
            }
        }
    }
}
